/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ExecutionHTNDecorator.java,v 1.5 2005/02/16 22:22:06 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator;

import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFVerdict;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;

/**
 * @author kdarcour
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 * @deprecated this class is replaced by org.eclipse.hyades.test.ui.internal.navigator.proxy.ExecutionFileProxyNode
 */
public class ExecutionHTNDecorator implements ILightweightLabelDecorator 
{
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ILightweightLabelDecorator#decorate(java.lang.Object, org.eclipse.jface.viewers.IDecoration)
	 */
	public void decorate(Object element, IDecoration decoration)
	{
		try
		{
			if (element instanceof TPFExecutionResult) 
			{
				TPFExecutionResult result = (TPFExecutionResult) element;

				switch (result.getVerdict().getValue())
				{
					case TPFVerdict.ERROR:
						decoration.addOverlay(ExecutionVerdictImages.errorVerdict);  break;
					case TPFVerdict.FAIL:
						decoration.addOverlay(ExecutionVerdictImages.failedVerdict);  break;
					case TPFVerdict.INCONCLUSIVE:
						decoration.addOverlay(ExecutionVerdictImages.inconclusiveVerdict); break; 
					case TPFVerdict.PASS:
						decoration.addOverlay(ExecutionVerdictImages.passedVerdict); break;
					default:
						return;	
				}
			}
		}
		catch (Exception e)
		{
			TestUIPlugin.logError(e);
		}
	}


	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IBaseLabelProvider#addListener(org.eclipse.jface.viewers.ILabelProviderListener)
	 */
	public void addListener(ILabelProviderListener listener) 
	{	
		// TODO Auto-generated method stub
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IBaseLabelProvider#dispose()
	 */
	public void dispose() 
	{
		// TODO Auto-generated method stub
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IBaseLabelProvider#isLabelProperty(java.lang.Object, java.lang.String)
	 */
	public boolean isLabelProperty(Object element, String property) 
	{
		// TODO Auto-generated method stub
		return false;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IBaseLabelProvider#removeListener(org.eclipse.jface.viewers.ILabelProviderListener)
	 */
	public void removeListener(ILabelProviderListener listener) 
	{
		// TODO Auto-generated method stub
	}
	
}