/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ExecutionResultHTNProvider.java,v 1.10 2005/03/02 23:41:34 bjiang Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionHistory;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFInvocationEvent;
import org.eclipse.hyades.models.common.testprofile.TPFVerdict;
import org.eclipse.hyades.test.ui.IHyadesTestNavigatorProvider;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.internal.model.ui.ITypeProviderFactory;
import org.eclipse.hyades.test.ui.internal.model.ui.VisibleTypes;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;


/**
 * @author kdarcour
 * @author jcanches
 */
public class ExecutionResultHTNProvider implements IHyadesTestNavigatorProvider, IExecutableExtension {

	private ITypeProviderFactory typeProvidersFactory;
	
	public ExecutionResultHTNProvider() {
		// By default, use providers registered as extensions
		this.typeProvidersFactory = VisibleTypes.getInstance();
	}
	
	public ExecutionResultHTNProvider(ITypeProviderFactory factory) {
		this.typeProvidersFactory = factory;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IBaseLabelProvider#dispose()
	 */
	public void dispose() 
	{
		// TODO Auto-generated method stub
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ITreeContentProvider#getChildren(java.lang.Object)
	 */
	public Object[] getChildren(Object parentElement) 
	{
		if (parentElement instanceof TPFExecutionResult) 
		{
			TPFExecutionResult result = (TPFExecutionResult) parentElement;
			IHyadesTestNavigatorProvider provider = typeProvidersFactory.getProvider(result.getType());
		    if (provider != null) {
			    return provider.getChildren(result);
		    }
			//- Default Hyades behavior
			TPFExecutionHistory history = result.getExecutionHistory();
			if ( history == null ) 
				return new Object[0];
			EList events = history.getExecutionEvents();

		    ArrayList results = new ArrayList();
		    
		    Iterator it = events.iterator();
		    while (it.hasNext()) 
		    {
				TPFExecutionEvent element = (TPFExecutionEvent) it.next();
				collectExecutionResults(element, results);
			}
			return results.toArray();
		}	
		return new Object[0];
	}
	
	private void collectExecutionResults( TPFExecutionEvent event, List list)
	{
		if ( event instanceof TPFInvocationEvent)
		{
			TPFInvocationEvent invok = (TPFInvocationEvent)event;
			list.add(invok.getInvokedExecutionResult());
		}
		else 
		{
			Iterator it = event.getChildren().iterator();
			while (it.hasNext()) {
				TPFExecutionEvent element = (TPFExecutionEvent) it.next();
				collectExecutionResults(element, list);
			}
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IStructuredContentProvider#getElements(java.lang.Object)
	 */
	public Object[] getElements(Object inputElement) 
	{
		return getChildren(inputElement);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ILabelProvider#getImage(java.lang.Object)
	 */
	public Image getImage(Object element) 
	{
		if (element instanceof TPFExecutionResult) 
		{
			TPFExecutionResult result = (TPFExecutionResult) element;
		    IHyadesTestNavigatorProvider provider = typeProvidersFactory.getProvider(result.getType());
		    if (provider != null) {
			    return provider.getImage(result);
		    }
		}
		//- Default Hyades behavior
		return TestUIImages.INSTANCE.getImage(TestUIImages.IMG_EXECUTION);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ITreeContentProvider#getParent(java.lang.Object)
	 */
	public Object getParent(Object element) 
	{
		if (element instanceof TPFExecutionResult) 
		{
			TPFExecutionResult executionResult = (TPFExecutionResult) element;
		    IHyadesTestNavigatorProvider provider = typeProvidersFactory.getProvider(executionResult.getType());
		    if (provider != null) {
			    return provider.getParent(executionResult);
		    }
			
			//- Default Hyades behavior
			if (executionResult.getInvocationExecutionEvent() == null)
				return EMFUtil.getParent(EMFUtil.getResource(null,executionResult)); 
				//- returns the IFile
			else
			{ 	TPFExecutionEvent event = executionResult.getInvocationExecutionEvent();
			//- skip all reflexive execution events
				while(event.getParent() != null) {
					event = event.getParent();
				}
				return (event.getExecutionHistory()).getExecutionResult(); 
				//- returns a TPFExecutionResult
			}
		}
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ILabelProvider#getText(java.lang.Object)
	 */
	public String getText(Object element) 
	{
		if (element instanceof TPFExecutionResult) 
		{
			TPFExecutionResult executionResult = (TPFExecutionResult) element;
		    IHyadesTestNavigatorProvider provider = typeProvidersFactory.getProvider(executionResult.getType());
		    if (provider != null) {
			    return provider.getText(executionResult);
		    }

			//- Default Hyades behavior
			String name;
			if ( executionResult.getName() != null )
			    name = executionResult.getName();
			else 
				name = "unamed"; //$NON-NLS-1$
			if (( executionResult.getTest() != null) 
			   && (((executionResult.getTest()).getName()) != null))
				name += " [" + (executionResult.getTest()).getName() + "]"; //$NON-NLS-1$ //$NON-NLS-2$
					
 			return name;
		}
		return ""; //$NON-NLS-1$
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ITreeContentProvider#hasChildren(java.lang.Object)
	 */
	public boolean hasChildren(Object element) 
	{
		if (element instanceof TPFExecutionResult) 
		{
			TPFExecutionResult result = (TPFExecutionResult) element;
		    IHyadesTestNavigatorProvider provider = typeProvidersFactory.getProvider(result.getType());
		    if (provider != null) {
			    return provider.hasChildren(result);
		    }

			//- Default Hyades behavior
			TPFExecutionHistory history = result.getExecutionHistory();
			if ( history == null ) 
				return false;
			EList events = history.getExecutionEvents();

		    ArrayList results = new ArrayList();
		    
		    Iterator it = events.iterator();
		    while (it.hasNext()) 
		    {
				TPFExecutionEvent event = (TPFExecutionEvent) it.next();
				collectExecutionResults(event, results);
			}
			return (!results.isEmpty());
		}	
		return false;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IContentProvider#inputChanged(org.eclipse.jface.viewers.Viewer, java.lang.Object, java.lang.Object)
	 */
	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see org.eclipse.core.runtime.IExecutableExtension#setInitializationData(org.eclipse.core.runtime.IConfigurationElement, java.lang.String, java.lang.Object)
	 */
	public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IBaseLabelProvider#addListener(org.eclipse.jface.viewers.ILabelProviderListener)
	 */
	public void addListener(ILabelProviderListener listener) {
		// TODO Auto-generated method stub

	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IBaseLabelProvider#isLabelProperty(java.lang.Object, java.lang.String)
	 */
	public boolean isLabelProperty(Object element, String property) 
	{
		if (element instanceof TPFExecutionResult) 
		{
			TPFExecutionResult result = (TPFExecutionResult) element;
		    IHyadesTestNavigatorProvider provider = typeProvidersFactory.getProvider(result.getType());
		    if (provider != null) {
			    return provider.isLabelProperty(result, property);
		    }
		}
		//- Default Hyades behavior
		// TODO Auto-generated method stub
		return false;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IBaseLabelProvider#removeListener(org.eclipse.jface.viewers.ILabelProviderListener)
	 */
	public void removeListener(ILabelProviderListener listener) {
		// TODO Auto-generated method stub

	}

	/** This method returns the verdict of the passed element, in this case there is no status
	 * because this is not an execution node.
	 * @param element the element in the Test Navigator
	 * @return  IHyadesTestNavigatorProvider.VERDICT_NONE
	 */
	public int getVerdict(Object element)
	{
		if (element instanceof TPFExecutionResult) 
		{
			TPFExecutionResult result = (TPFExecutionResult) element;
		    IHyadesTestNavigatorProvider provider = typeProvidersFactory.getProvider(result.getType());
		    if (provider != null) {
			    return provider.getVerdict(result);
		    }
			
			//- Default Hyades behavior
			switch (result.getVerdict().getValue())
			{
				case TPFVerdict.ERROR:
					return IHyadesTestNavigatorProvider.VERDICT_ERROR; 
				case TPFVerdict.FAIL:
					return IHyadesTestNavigatorProvider.VERDICT_FAILED;
				case TPFVerdict.INCONCLUSIVE:
					return IHyadesTestNavigatorProvider.VERDICT_INCONCLUSIVE;
				case TPFVerdict.PASS:
					return IHyadesTestNavigatorProvider.VERDICT_PASSED;
				default:
					return IHyadesTestNavigatorProvider.VERDICT_NONE;
			}
		}
		return IHyadesTestNavigatorProvider.VERDICT_NONE;
	}

}
