/* 
* Licensed Materials - Property of IBM
* 
* com.ibm.rational.test.ct
* 
* (c) Copyright IBM Corporation 2005. All Rights Reserved. 
* Note to U.S. Government Users Restricted Rights:  Use, duplication or disclosure restricted by GSA ADP  Schedule Contract with IBM Corp. 
*/

package org.eclipse.hyades.test.ui.internal.navigator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.resources.IFile;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.FileProxyManager;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;

/**
 * @author jgout
 */
public class TestDecoratingLabelProvider extends DecoratingLabelProvider implements ILabelProviderListener{

	private LinkedList listeners;
	private final TestNavigator testNavigator;
	/**
	 * @param provider
	 * @param decorator
	 * @param testNavigator
	 */
	public TestDecoratingLabelProvider(ILabelProvider provider, ILabelDecorator decorator, TestNavigator testNavigator) {
		super(provider, decorator);
		this.testNavigator = testNavigator;
		listeners = new LinkedList();
	}
	
	public void addListener(ILabelProviderListener listener) {
		ILabelDecorator decorator = getLabelDecorator();
		if(decorator != null) {
			decorator.addListener(this);
		}
		//- avoid multiple listener registration
		if(!listeners.contains(listener)) {
			ILabelProvider labelProvider = getLabelProvider();
			if(labelProvider != null) {
				labelProvider.addListener(listener);
			}
			listeners.add(listener);
		}
	}
	
	public void removeListener(ILabelProviderListener listener) {
		ILabelDecorator decorator = getLabelDecorator();
		if(decorator != null) {
			decorator.removeListener(this);
		}
		if(listeners.contains(listener)) {
			ILabelProvider labelProvider = getLabelProvider();
			if(labelProvider != null) {
				labelProvider.removeListener(listener);
			}
			listeners.remove(listener);
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ILabelProviderListener#labelProviderChanged(org.eclipse.jface.viewers.LabelProviderChangedEvent)
	 */
	public void labelProviderChanged(LabelProviderChangedEvent event) {
		Object [] elements = event.getElements();
		ArrayList others= new ArrayList();
		
		for (int i = 0; i < elements.length; i++) {
			Object elem = elements[i];
			if(elem instanceof IFile) {
				//- need to check is there is not a proxy define for this file
				IFile file = (IFile)elem;
				if(file.exists()) {
					Object convertedObject = FileProxyManager.getInstance().getProxy(file);
					if(convertedObject == null) {
						//- old stuff for compatibility
						//- if the file should be converted through a special converter, use it
						convertedObject = testNavigator.getConvertedObjectFromFile(file);
					}
					if(convertedObject != null) {
						others.add(convertedObject);
					} else {
						others.add(elem);
					}
				} else {
					others.add(elem);
				}
			} else {
				others.add(elem);
			}
		}
		event = new LabelProviderChangedEvent((IBaseLabelProvider) event.getSource(), others.toArray());
		//- delegate to all registered listeners with the new event content
		for (Iterator it = listeners.iterator(); it.hasNext();) {
			ILabelProviderListener l = (ILabelProviderListener) it.next();
			l.labelProviderChanged(event);
		}
	}
}
