/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestSuiteHTNConverter.java,v 1.5 2005/02/16 22:22:06 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.testprofile.impl.TPFTestSuiteImpl;
import org.eclipse.hyades.models.common.util.ICommonConstants;
import org.eclipse.hyades.test.ui.IHyadesTestNavigatorConverter;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;

/**
 * TODO: Provide description for "TestSuiteHTNConverter".
/** @author jgout */
public class TestSuiteHTNConverter implements IHyadesTestNavigatorConverter {
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.IHyadesTestNavigatorConverter#getObjectFromResource(org.eclipse.core.resources.IResource)
	 */
	public Object getObjectFromResource(IResource file) {
		//- returns the first TPFTestSuite found in the EMF file
//		String name = file.getName();
		String ext = file.getFileExtension();
		if (ext!=null && ext.equals(ICommonConstants.TEST_SUITE_FILE_EXTENSION)) {
			EObject[] eObjects = EMFUtil.load(null, (IFile) file);
			for (int i = 0; i < eObjects.length; i++) {
				if (eObjects[i] instanceof TPFTestSuiteImpl) {
					return (TPFTestSuiteImpl) eObjects[i];
				}
			}
		}
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.core.runtime.IExecutableExtension#setInitializationData(org.eclipse.core.runtime.IConfigurationElement, java.lang.String, java.lang.Object)
	 */
	public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
	}

}
