/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ControlEventAction.java,v 1.9 2005/02/16 22:22:06 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.test.ui.internal.navigator.action;

import org.eclipse.core.resources.IResourceStatus;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.models.common.configuration.CFGMachineConstraint;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionHistory;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionType;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTypedEvent;
import org.eclipse.hyades.test.ui.TestUI;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.ui.internal.util.StringUtil;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.help.WorkbenchHelp;

public abstract class ControlEventAction 
extends Action implements IDisposable
{
	private IStructuredSelection structuredSelection;
	private String m_controlEvent = null;
	private String m_text = null;

	public ControlEventAction(String controlEvent, String text, String contextID)
	{
		super(TestUIPlugin.getString(text));
		WorkbenchHelp.setHelp(this, TestUIPlugin.getID() + contextID);												
		m_controlEvent = controlEvent;
		m_text = text;
	}
	
	public void dispose()
	{
		structuredSelection = null;
	}

	protected IStructuredSelection getStructuredSelection()
	{
		return structuredSelection;
	}
	
	public void selectionChanged(IStructuredSelection structuredSelection)
	{
		this.structuredSelection = structuredSelection;
	}

	public void run()
	{
		IStructuredSelection selection = getStructuredSelection();
		
		if(selection != null && !selection.isEmpty())
		{
			Object object = selection.getFirstElement();
			if(object instanceof TPFExecutionResult)
			{
				TPFExecutionResult execResult = (TPFExecutionResult)object;
				TPFTest test = execResult.getTest();
				
				ITestSuite testSuite = null;
				if(test instanceof ITestSuite)
					testSuite = (ITestSuite)test;
				else if(test instanceof ITestCase)
					testSuite = ((ITestCase)test).getOwner();
				 
				// TODO
				// port always seems to be the same.  Launch test uses the same constant.
				String port = TestUIPlugin.getInstance().getPreferenceStore().getString(TestUI.LOCALHOST_PORT);

				TPFDeployment deployment = execResult.getDeployment();
				EList list = deployment.getLocations();
				boolean fError = true;
				String errors = new String();
				// Test is only running on one of the locations in the deployment.
				// If control event is successful for any of the location, it is a success.
				for (int i = 0; i < list.size(); i++){
					CFGLocation loc = (CFGLocation) list.get(i);
					String machineName = ((CFGMachineConstraint)loc).getHostname();				
					String error = new org.eclipse.hyades.execution.harness.TestExecutionHarness().performControlEvent(testSuite, (ITest)test, loc, port, execResult, m_controlEvent, null);
					if (error == null)
					{						
						fError = false;
					}else{
						errors = errors + error + "\r"; //$NON-NLS-1$
					}
				}
				if (fError){
					String errMsg = TestUIPlugin.getString("CONTROL_EVT_FAIL_TEXT"); //$NON-NLS-1$
					errMsg = StringUtil.replace(errMsg, "%1", TestUIPlugin.getString(m_text)); //$NON-NLS-1$
					errMsg = StringUtil.replace(errMsg, "%2", deployment.getName()); //$NON-NLS-1$
		
					Status err1 = new Status(IStatus.WARNING, ResourcesPlugin.PI_RESOURCES, IResourceStatus.INTERNAL_ERROR, errors, null);
		
					ErrorDialog.openError(null, TestUIPlugin.getString("TEST_ERR_MSG"), errMsg, err1); //$NON-NLS-1$
				}
			} 
		}
		structuredSelection = null;
	}

	public boolean isApplicableForSelection()
	{
		if((structuredSelection == null) || (structuredSelection.size() != 1))
			return false;

		Object selection = structuredSelection.getFirstElement();
		if(selection instanceof TPFExecutionResult)
		{
			return true;
		}
		return false;
	}
	
	public boolean isApplicableForEnablement(){
		if((structuredSelection == null) || (structuredSelection.size() != 1))
			return false;

		Object selection = structuredSelection.getFirstElement();
		boolean canBePerformed = false;
		if(selection instanceof TPFExecutionResult)
		{
			TPFExecutionResult execResult = (TPFExecutionResult) selection;

			TPFExecutionHistory execHistory = execResult.getExecutionHistory();
			EList execEvents = execHistory.getExecutionEvents();
			if (execEvents.size() > 0){
				Object obj = execEvents.get(execEvents.size()-1);
				if (obj instanceof TPFTypedEvent){
					TPFTypedEvent execEvent = (TPFTypedEvent) obj;
					TPFExecutionType type = execEvent.getType();
					if (type.getValue() == TPFExecutionType.STOP){
						return false;
					}
				}
			} 
			TPFTest test = execResult.getTest();
				
			ITestSuite testSuite = null;
			if(test instanceof ITestSuite)
				testSuite = (ITestSuite)test;
			else if(test instanceof ITestCase)
				testSuite = ((ITestCase)test).getOwner();
				 
			// TODO
			// port always seems to be the same.  Launch test uses the same constant.
			String port = TestUIPlugin.getInstance().getPreferenceStore().getString(TestUI.LOCALHOST_PORT);

			TPFDeployment deployment = execResult.getDeployment();
			EList list = deployment.getLocations();
			for (int i = 0; i < list.size(); i++){
				CFGLocation loc = (CFGLocation) list.get(0);
				String machineName = ((CFGMachineConstraint)loc).getHostname();				
				canBePerformed = new org.eclipse.hyades.execution.harness.TestExecutionHarness().canSupportControlEvent(testSuite, (ITest)test, loc, port, execResult, m_controlEvent);
				if (!canBePerformed){
					break;
				}
			}
		}
		return canBePerformed;
	}
	
}
