/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ExportAction.java,v 1.3 2005/02/16 22:22:06 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.action;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.actions.ActionFactory;

/**
 * @author CERVILLA
 * @since 3.3
 *
 */
public class ExportAction implements IViewActionDelegate {
	
	private ActionFactory.IWorkbenchAction exportAction;
	
	public void init(IViewPart view) {
		exportAction =
			ActionFactory.EXPORT.create(view.getViewSite().getWorkbenchWindow()); 
	}

	public void run(IAction action) {
		exportAction.run();
	}

	public void selectionChanged(IAction action, ISelection selection) {
	}


}
