/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: OpenReportAction.java,v 1.9 2005/04/22 19:10:05 bjiang Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.test.ui.internal.navigator.action;

import java.util.Iterator;

import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.DefaultTestCaseProxyNode;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.DefaultTestSuiteProxyNode;
import org.eclipse.hyades.test.ui.internal.util.ContextIds;
import org.eclipse.hyades.test.ui.internal.wizard.ReportWizard;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.WorkbenchHelp;

/*
* CONTEXT_ID owiz0000 for new wizard action
*/

public class OpenReportAction extends Action
{
  private IStructuredSelection selection;
  
  public OpenReportAction()
  {
	super(TestUIPlugin.getString("REPORT_TEXT")); //$NON-NLS-1$
	WorkbenchHelp.setHelp(this, TestUIPlugin.getID() + ContextIds.OPEN_REPORT_ACT);												
	

  }  
  
  public void run()
  {
	ReportWizard wizard = new ReportWizard();
	wizard.init(PlatformUI.getWorkbench(), selection);

	WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), wizard);
	dialog.open();
	wizard.dispose();	
	
	selection = null;		
  }
 
  public void selectionChanged(IStructuredSelection structuredSelection)
  {
  	selection = structuredSelection;
  }
  
  
  
  public boolean isApplicableForSelection()
  {
 	  if(selection == null || selection.isEmpty())
	     return false;
	     
  	  Iterator iterator = selection.iterator();
  	  while(iterator.hasNext())
  	  {
  	  	Object elem = iterator.next();
  	  	
  	  	if(!(elem instanceof DefaultTestSuiteProxyNode) && !(elem instanceof DefaultTestCaseProxyNode) && 
  	  	   !(elem instanceof TPFTest))
  	  	  return false;
  	  }
      
      return true;
  }

}
