/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ToggleEObjectChildrenAction.java,v 1.4 2005/02/16 22:22:06 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.action;

import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.navigator.TestNavigator;
import org.eclipse.hyades.test.ui.internal.util.ContextIds;
import org.eclipse.hyades.ui.internal.navigator.action.NavigatorAction;
import org.eclipse.ui.help.WorkbenchHelp;


/**
 * This action toggles whether the Test navigator should present the eObjects 
 * children.
 * 
 * @author marcelop
 * @since 0.2.0
 */
public class ToggleEObjectChildrenAction 
extends NavigatorAction
{
	/**
	 * Constructor for ToggleEObjectChildrenAction
	 * @param navigator
	 * @param label
	 */
	public ToggleEObjectChildrenAction(TestNavigator testNavigator, String label)
	{
		super(testNavigator, label);
		setChecked(testNavigator.isShowingEObjectChildren());
		WorkbenchHelp.setHelp(this, TestUIPlugin.getID() + ContextIds.TOGGLE_CHILD_ACT);												
		
	}

	/**
	 * @see org.eclipse.jface.action.IAction#run()
	 */
	public void run()
	{
		((TestNavigator)getNavigator()).setShowingEObjectChildren(isChecked());
	}
}
