/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DefaultExecutionResultProxyNode.java,v 1.5 2005/03/22 14:00:29 dguilbaud Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.navigator.proxy;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionHistory;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFInvocationEvent;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.TestUIConstants;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.internal.model.EventUtil;
import org.eclipse.hyades.test.ui.navigator.IExecutionResultProxyNode;
import org.eclipse.hyades.test.ui.navigator.IPersistableTypedElementProxyFactory;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITypedElementProxyFactory;
import org.eclipse.hyades.test.ui.navigator.TypedElementProxyNode;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;

/**
 * @author jgout
 * @since 3.2
 */
public class DefaultExecutionResultProxyNode extends TypedElementProxyNode implements IExecutionResultProxyNode {
	
	private IProxyNode[] children;
	
	/**
	 * @param er
	 * @param parent
	 */
	public DefaultExecutionResultProxyNode(TPFExecutionResult er, Object parent) {
		super(er, parent);
		
		String name;
		LinkedList c = new LinkedList();
		TPFExecutionHistory history = er.getExecutionHistory();
		if (history != null ) {
			EList events = history.getExecutionEvents();
			for (Iterator it = events.iterator(); it.hasNext();) {
				getEventChildren((TPFExecutionEvent) it.next(), c, er);
			}
		}
		children = (IProxyNode[]) c.toArray(new IProxyNode[c.size()]);
		//- save the name of this element
		if(er.getName() != null) {
			name = er.getName();
		} else {
			name = "unamed"; //$NON-NLS-1$
		}
		TPFTest test = er.getTest();
		if((test != null) && (((test).getName()) != null)) {
			if (test instanceof TPFTestSuite) {
				if (er.getExecutionHistory().getExecutionEvents()!=null && er.getExecutionHistory().getExecutionEvents().size()>0) {
					long timeStamp = ((TPFExecutionEvent)er.getExecutionHistory().getExecutionEvents().get(0)).getTimestamp();
					String dateStamp = EventUtil.getTime(timeStamp);
					name += " ["+dateStamp+"]";  //$NON-NLS-1$//$NON-NLS-2$
				}
			} else {
				name += " [" + (test).getName() + "]"; //$NON-NLS-1$ //$NON-NLS-2$
			}
		}
		setName(name);
	}

	public DefaultExecutionResultProxyNode(IMemento memento, Object parent) {
		super(memento, parent);
		IMemento [] childrenMemento = memento.getChildren(TestUIConstants.TAG_CHILD);
		for (int i = 0; i < childrenMemento.length; i++) {
			IMemento mementoChild = childrenMemento[i];
			String type = mementoChild.getString(TestUIConstants.TAG_TYPE);
			if(type == null) {
				throw new IllegalArgumentException("Malformed saved proxy state: unable to retrieve type field"); //$NON-NLS-1$
			}
			ITypedElementProxyFactory factory = TypedElementFactoryManager.getInstance().getFactory(type);
			if(factory instanceof IPersistableTypedElementProxyFactory) {
				((IPersistableTypedElementProxyFactory)factory).recreate(mementoChild, this);
			}
		}
	}
	
	/**
	 * @param event
	 * @param parent
	 */
	private void getEventChildren(TPFExecutionEvent event, List c, TPFExecutionResult parent) {
		if ( event instanceof TPFInvocationEvent) {
			TPFExecutionResult er = ((TPFInvocationEvent)event).getInvokedExecutionResult();
			c.add(new DefaultExecutionResultProxyNode(er, parent));
		} else {
			Iterator iterator = event.getChildren().iterator();
			while (iterator.hasNext()) {
				getEventChildren((TPFExecutionEvent) iterator.next(), c, parent);
			}
		}
	}

	public Image getImage() {
		return TestUIImages.INSTANCE.getImage(TestUIImages.IMG_EXECUTION);
	}
	
	public IProxyNode[] getChildren() {
		return children;
	}
		
	public TPFExecutionResult getExecutionResult() {
		EObject exec = EMFUtil.getResourceSet().getEObject(getOriginatorURI(), true);
		if (exec instanceof TPFExecutionResult) {
			return (TPFExecutionResult) exec;
		} else {
			return null;
		}
	}
}
