/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestSuiteAssociation.java,v 1.8 2005/02/16 22:22:11 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.preference;

import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.util.ContextIds;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.extension.IAssociationMapping;
import org.eclipse.hyades.ui.extension.IAssociationMappingRegistry;
import org.eclipse.hyades.ui.internal.extension.AssociationMappingRegistry;
import org.eclipse.hyades.ui.internal.preference.AssociationMappingPreferencePage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.help.WorkbenchHelp;

/**
 * Preference page to customize the test suite associations.
 * 
 * @author marcelop
 * @since 0.0.1
 */
public class TestSuiteAssociation 
extends AssociationMappingPreferencePage
{
	private IAssociationMappingRegistry registry;
	
	/**
	 * Constructor for TestSuiteAssocitation
	 */
	public TestSuiteAssociation()
	{
		super();	
		registry = (AssociationMappingRegistry)TestUIExtension.getTestSuiteMappingRegistry();
	}

	/**
	 * @see org.eclipse.hyades.ui.internal.preference.AssociationMappingPreferencePage#beforeIsPresented()
	 */
	protected void beforeIsPresented()
	{
		registry.checkpoint();
	}

	/**
	 * @see org.eclipse.jface.dialogs.IDialogPage#dispose()
	 */
	public void dispose()
	{
		registry.clearCheckpoint();
		registry = null;
		
		super.dispose();
	}

	/**
	 * @see org.eclipse.hyades.ui.internal.preference.AssociationPreferencePage#getSelectionAssociationMapping()
	 */
	protected IAssociationMapping getSelectionAssociationMapping()
	{
		return registry.getAssociationMapping(HyadesUIPlugin.EP_TYPE_DESCRIPTIONS);
	}

	/**
	 * @see org.eclipse.hyades.ui.internal.preference.AssociationRegistryPreferencePage#getDetailMappings()
	 */
	public IAssociationMapping[] getDetailMappings()
	{
		// Run Wizards are deprecated and replaced by Run Configuration.
		//IAssociationMapping[] associationMappings = new IAssociationMapping[3];
		IAssociationMapping[] associationMappings = new IAssociationMapping[2];
		associationMappings[0] = registry.getAssociationMapping(HyadesUIPlugin.EP_EDITOR_EXTENSIONS);
		associationMappings[1] = registry.getAssociationMapping(TestUIPlugin.EP_GENERATE_WIZARDS);
		//associationMappings[2] = registry.getAssociationMapping(TestUIPlugin.EP_RUN_WIZARDS);		
		return associationMappings;
	}

	/**
	 * @see org.eclipse.hyades.ui.internal.preference.AssociationPreferencePage#getSelectionLabel()
	 */
	public String getSelectionLabel()
	{
		return TestUIPlugin.getString("testSuiteSelectionLabel"); //$NON-NLS-1$
	}

	/**
	 * @see org.eclipse.hyades.ui.internal.preference.AssociationPreferencePage#getLabel(IAssociationMapping)
	 */
	protected String getLabel(IAssociationMapping associationMapping)
	{
		if(HyadesUIPlugin.EP_TYPE_DESCRIPTIONS.equals(associationMapping.getExtensionPoint()))
			return TestUIPlugin.getString("LBL_TST_SUITE_TYPE_DSC"); //$NON-NLS-1$

		if(HyadesUIPlugin.EP_EDITOR_EXTENSIONS.equals(associationMapping.getExtensionPoint()))
			return TestUIPlugin.getString("TAB_EDT_EXTS"); //$NON-NLS-1$

		if(TestUIPlugin.EP_GENERATE_WIZARDS.equals(associationMapping.getExtensionPoint()))
			return TestUIPlugin.getString("TAB_GEN_WIZ"); //$NON-NLS-1$

		// Run Wizards are deprecated and replaced by Run Configuration
		//if(TestUIPlugin.EP_RUN_WIZARDS.equals(associationMapping.getExtensionPoint()))
			//return TestUIPlugin.getString("TAB_RUN_WIZ"); //$NON-NLS-1$
			
		return null;
	}
	
	/**
	 * @see org.eclipse.jface.preference.IPreferencePage#performCancel()
	 */
	public boolean performCancel()
	{
		return registry.rollback();
	}

	/**
	 * @see org.eclipse.jface.preference.IPreferencePage#performOk()
	 */
	public boolean performOk()
	{
		if(!registry.commit())
			return false;
			
		TestUIPlugin.getInstance().savePluginPreferences();
		return true;
	}
	
	protected Control createContents(Composite parent)
	{
		Control control = super.createContents(parent);
		
		WorkbenchHelp.setHelp(parent, TestUIPlugin.getID() + ContextIds.ASSOC_PREF_CONT);												
		
		return control;
	}	
	
}
