/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ArtifactSelectionPage.java,v 1.8 2005/03/16 23:09:35 bjiang Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.wizard;

import java.util.Vector;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.util.ICommonConstants;
import org.eclipse.hyades.test.ui.internal.component.EObjectResourceSelectionViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;

/**
 * @author psun
 * @author JLHoover 9/23/04
 * 
 * To change the template for this generated type comment go to Window -
 * Preferences - Java - Code Generation - Code and Comments
 */
public class ArtifactSelectionPage extends WizardPage {

	private String[] fileExtensions;
	private Image fileImage;
	private EObject[] selectedEObjects;
	private EObject[] checkedEObjects;
	private Vector checkedObjects;
	EObjectResourceSelectionViewer viewer;
	
	/**
	 * @param pageName
	 */
	protected ArtifactSelectionPage(String pageName) {
		super(pageName);
		fileExtensions = getSupportedFileExtensions();
	}

	private String[] getSupportedFileExtensions() {
		return new String[] { ICommonConstants.TEST_SUITE_FILE_EXTENSION,
				ICommonConstants.TEST_COMPONENT_EXTENSION,
				ICommonConstants.SUT_EXTENSION,
				ICommonConstants.DATAPOOL_FILE_EXTENSION };
	}
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.dialogs.IDialogPage#createControl(org.eclipse.swt.widgets.Composite)
	 */
	public void createControl(Composite parent) {
		Composite composite= new Composite(parent, SWT.NULL);
		composite.setLayout(new GridLayout());
		composite.setLayoutData(
			new GridData(GridData.VERTICAL_ALIGN_FILL | GridData.HORIZONTAL_ALIGN_FILL));

		viewer = new EObjectResourceSelectionViewer(composite,
					ResourcesPlugin.getWorkspace().getRoot(),
					fileExtensions,
					SWT.MULTI | SWT.FULL_SELECTION | SWT.BORDER);
				
		setControl(composite);

	}

	public EObject[] getSelectedObjects() {
		return viewer.getSelectedObjects();
	}

	public IFile[] getSelectedFiles() {
		return viewer.getSelectedFiles();
	}


}