/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DatapoolExportSelectionPage.java,v 1.4 2005/05/05 23:06:23 bjiang Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.wizard;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.models.common.util.ICommonConstants;
import org.eclipse.hyades.test.ui.datapool.internal.util.GridDataUtil;
import org.eclipse.hyades.test.ui.internal.component.EObjectResourceSelectionViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;

/**
 * @author psun
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class DatapoolExportSelectionPage extends WizardPage implements SelectionListener {
	
	IDatapool datapool = null;
	private String[] fileExtensions;
	private Image fileImage;
	private EObjectResourceSelectionViewer viewer;
	
	/**
	 * @param pageName
	 */
	protected DatapoolExportSelectionPage(String pageName) 
	{
		super(pageName);
		fileExtensions = getSupportedFileExtensions();
		setPageComplete(false);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.IDialogPage#createControl(org.eclipse.swt.widgets.Composite)
	 */
	public void createControl(Composite parent) 
	{
        Composite composite = new Composite(parent, SWT.NONE);		
		GridLayout layout = new GridLayout();
		composite.setLayout(layout);
		GridData gridData = GridDataUtil.createFill();
		composite.setLayoutData(gridData);
		
		viewer = new EObjectResourceSelectionViewer(composite,
				ResourcesPlugin.getWorkspace().getRoot(),
				fileExtensions,
				SWT.FULL_SELECTION | SWT.BORDER);
		((Tree)viewer.getViewer().getControl()).addSelectionListener(this);
		
		setControl(composite);
		
	}
	
	public IDatapool getDatapool()
	{
		return datapool;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	public void widgetSelected(SelectionEvent e) 
	{
		if(e.widget == viewer.getViewer().getControl())
		{
			setSelection();
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	public void widgetDefaultSelected(SelectionEvent e) 
	{
		
	}


	private void setSelection()
	{
		EObject[] selectedObjects = viewer.getSelectedObjects();
		if ( selectedObjects.length > 0 )
		{
			Object selectedObject = selectedObjects[0];
			if(selectedObject instanceof IDatapool)
			{
				datapool = (IDatapool)selectedObject; 
				if(datapool != null)
				{
					setPageComplete(true);
					getContainer().updateButtons();
				}
			}
		}
	}
			
	private String[] getSupportedFileExtensions()
	{
	    return new String[]{ICommonConstants.DATAPOOL_FILE_EXTENSION};
	}
	
	
}
