/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestComponentNewWizard.java,v 1.6 2005/02/16 22:22:12 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.wizard;

import org.eclipse.hyades.models.common.testprofile.Common_TestprofileFactory;
import org.eclipse.hyades.models.common.testprofile.TPFBehavior;
import org.eclipse.hyades.models.common.testprofile.TPFTestComponent;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.ui.internal.wizard.HyadesWizard;
import org.eclipse.hyades.ui.internal.wizard.NameAndDescriptionWizardPage;
import org.eclipse.ui.model.IWorkbenchAdapter;

/**
 * Wizard for Test Component
 * @author marcelop
 * @since 0.2.0
 */
public class TestComponentNewWizard
extends HyadesWizard
{
	private NameAndDescriptionWizardPage nameAndDescriptionWizardPage;
	
	/**
	 * Constructor for TestComponentNewWizard
	 */
	public TestComponentNewWizard()
	{
		super();

		setWindowTitle(TestUIPlugin.getString("WIZ_TST_CMP_TTL")); //$NON-NLS-1$
	}

	/**
	 * Returns the "name and description page" used by this wizard.
	 * @return NameDescriptionWizardPage
	 */
	protected NameAndDescriptionWizardPage getNameAndDescriptionWizardPage()
	{
		return nameAndDescriptionWizardPage;
	}
	
	/**
	 * @see org.eclipse.hyades.ui.internal.wizard.HyadesWizard#initPages()
	 */
	protected void initPages()
	{
	    nameAndDescriptionWizardPage = new NameAndDescriptionWizardPage("nameDescription"); //$NON-NLS-1$
	}
	
	/**
	 * @see org.eclipse.jface.wizard.IWizard#addPages()
	 */
	public void addPages()
	{
		TPFTestSuite testSuite = (TPFTestSuite)getSelection().getFirstElement();
		String label = ((IWorkbenchAdapter)testSuite.getAdapter(IWorkbenchAdapter.class)).getLabel(testSuite);

		getNameAndDescriptionWizardPage().setTitle(TestUIPlugin.getString("WIZ_TST_CMP_GEN_PG_TTL")); //$NON-NLS-1$
		getNameAndDescriptionWizardPage().setDescription(TestUIPlugin.getString("WIZ_TST_CMP_GEN_PG_ATT_DSC", label)); //$NON-NLS-1$
		addPage(getNameAndDescriptionWizardPage());
	}

	/**
	 * @see org.eclipse.jface.wizard.IWizard#performFinish()
	 */
	public boolean performFinish()
	{
		TPFTestComponent testComponent = Common_TestprofileFactory.eINSTANCE.createTPFTestComponent();
		testComponent.setName(getNameAndDescriptionWizardPage().getItemName());
		testComponent.setDescription(getNameAndDescriptionWizardPage().getItemDescription());
		
		if(testComponent.getBehaviors().isEmpty())
		{
			TPFBehavior behavior = Common_TestprofileFactory.eINSTANCE.createTPFBehavior();
			testComponent.getBehaviors().add(behavior);
		} 
		
		TPFTestSuite testSuite = (TPFTestSuite)getSelection().getFirstElement();
		testSuite.getTestComponents().add(testComponent);
		
		return true;
	}
}
