/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: BasicTestLaunchConfigurationDelegate.java,v 1.11 2005/02/16 22:22:13 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.launch.delegates;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.hyades.execution.core.IExecutor;
import org.eclipse.hyades.execution.harness.TestExecutionHarness;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.models.common.util.SaveManager;
import org.eclipse.hyades.test.ui.TestUI;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.launch.configurations.DeploymentLaunchConfigurationFacade;
import org.eclipse.hyades.test.ui.launch.configurations.ExecutionHistoryLaunchConfigurationFacade;
import org.eclipse.hyades.test.ui.launch.configurations.TestLaunchConfigurationFacade;

/**
 * This class is the Delegate for the basic Hyades Launch Configuration.
 * It handles the launching of a Hyades Test according to a Hyades Launch Configuration.
 * @see ILaunchConfigurationDelegate
 * @author jcanches
 * @deprecated Use BasicTestLaunchConfigurationDelegate2 instead.
 */
public class BasicTestLaunchConfigurationDelegate extends AbstractLaunchConfigurationDelegate {
	
    /**
     * Create a Hyades Basic Launch Configuration Delegate.
     */
    public BasicTestLaunchConfigurationDelegate() {
    }

    protected TPFTest getLaunchedTest(ILaunchConfiguration configuration) throws CoreException {
    	return TestLaunchConfigurationFacade.getTest(configuration, getResourceSet());
    }
    
    protected TPFDeployment getDeployment(ILaunchConfiguration configuration) throws CoreException {
    	// TODO It seems that the fix for bugzilla 68195 requires to use the EMFUtil's ResourceSet
    	// (this Resource Set is the Test Navigator's Resource Set and should be read-only).
    	// I'm preserving the fix but things need to be investigated because the returned
    	// deployment should belong to the Delegate's Resource Set.
    	
    	TPFDeployment depl = DeploymentLaunchConfigurationFacade.getDeployment(configuration, EMFUtil.getResourceSet());
    	// Should be:
    	// TPFDeployment depl = DeploymentLaunchConfigurationFacade.getDeployment(configuration, getResourceSet());
    	
    	if (depl != null) {
    		// reloading before execution makes deployment lost un-persisited data and thus becomes unusable
    		// bugzillag # 68195
	    	//EObject obj = EMFUtil.getEObjectInResourceSet(depl, new ResourceSetImpl());
	    	//depl = (TPFDeployment)obj;
	    	
	    	// adjust the deployment to allow for default location, if necessary
	    	// modified DeploymentUtil.associateTestAsset() to adjustDefaultLocation first
	    	// before creating a pair in memory since associateTestAsset() is the central place adjusting all deployment.
	    	// called by DeploymentLaunchConfigurationFacade.getDeployment() above.
	    	// bugzilla # 65607
	    	//ArtifactUtil.adjustDefaultLocation(depl, getLaunchedTest(configuration));
	    	return depl;
    	}
    	return null;
    }
    
    protected String getTestExecutionHistoryName(ILaunchConfiguration configuration) throws CoreException {
    	return ExecutionHistoryLaunchConfigurationFacade.getExecutionHistoryName(configuration);
    }
    
    protected IContainer getTestExecutionHistoryLocation(ILaunchConfiguration configuration) throws CoreException {
    	return ExecutionHistoryLaunchConfigurationFacade.getExecutionHistoryLocation(configuration);
    }   
    
    protected boolean overrideExistingTestExecutionHistory(ILaunchConfiguration configuration) throws CoreException {
    	return ExecutionHistoryLaunchConfigurationFacade.isExecutionHistoryOverriden(configuration);
    }
    
	protected Object getLaunchedElement(ILaunchConfiguration configuration)	throws CoreException {
		return getLaunchedTest(configuration);
	}
	
    protected void validate(ILaunchConfiguration configuration, String mode) throws CoreException {
    	super.validate(configuration, mode);
   	
    	if (getDeployment(configuration) == null) {
			reportProblem("The configuration does not provide a Deployment"); //$NON-NLS-1$
		}
    	
    	String tehName = getTestExecutionHistoryName(configuration);
    	if (tehName == null || tehName.equals("")) { //$NON-NLS-1$
    		reportProblem("The configuration does not provide a Test Execution History Name"); //$NON-NLS-1$
    	}
    	
    	IContainer tehLocation = getTestExecutionHistoryLocation(configuration);
    	if (tehLocation == null) {
    		reportProblem("The configuration does not provide a Test Execution History Location"); //$NON-NLS-1$
    	} else if (!tehLocation.exists()) {
    		reportProblem("The Test Execution History Location described by the configuration does not exist"); //$NON-NLS-1$
    	}
    }
	
    
    /**
     * Launch a Hyades Test.
     * @see ILaunchConfigurationDelegate#launch
     */
    public IExecutor invokeTestExecutionHarness(ILaunchConfiguration configuration, String mode, StringBuffer errorMessages) throws CoreException {
		// Compute parameters
    	TPFTest test = getLaunchedTest(configuration);
    	TPFTestSuite testSuite = null;
    	TPFTest subTest = null;
    	if (test instanceof TPFTestCase) {
    		subTest = test;
    		testSuite = ((TPFTestCase)subTest).getTestSuite();
    	} else if (test instanceof TPFTestSuite) {
    		testSuite = (TPFTestSuite)test;
    		subTest = test;
    	}
    	
    	TPFDeployment deployment = getDeployment(configuration);	    	
    	String tehName = getTestExecutionHistoryName(configuration);
    	String tehLocation = getTestExecutionHistoryLocation(configuration).getFullPath().toString();
    	boolean overrideExistingExecHistory = overrideExistingTestExecutionHistory(configuration);
    	String port = TestUIPlugin.getInstance().getPreferenceStore().getString(TestUI.LOCALHOST_PORT);
    	
		TestExecutionHarness teh = new TestExecutionHarness();
		IExecutor executor = teh.launchTest(
			(ITestSuite)testSuite,
			(ITest)subTest,
			deployment,
			port,
			tehLocation,
			tehName,
			overrideExistingExecHistory,
			true,
			false,
			errorMessages);
		SaveManager.getInstance().start(TestUIPlugin.getInstance().getPreferenceStore().getLong(TestUI.SAVE_INTERVAL));
		return executor;
    }
    
}
