/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IDeploymentsProvider.java,v 1.4 2005/02/16 22:22:13 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.launch.extensions;

import org.eclipse.hyades.models.common.testprofile.TPFDeployment;

/**
 * This interface is to be implemented by plugins extending the org.eclipse.hyades.test.ui.deploymentProvider
 * extension point.
 * @author jcanches
 */
public interface IDeploymentsProvider {
	
	/**
	 * Returns the available deployments for the supplied test element.
	 * @param testElement This may be an instance of TPFTest, or TPFTestComponent.
	 * @return The available deployments for the supplied test element. The returned array
	 * may be 0-sized, but is not expected to be null. All the returned deployments must
	 * belong to a persisted EMF resource.
	 **/
	public TPFDeployment[] getDeployments(Object testElement);
	
	/**
	 * Returns the default deployment for the supplied test element.
	 * @param testElement This may be an instance of TPFTest, or TPFTestComponent.
	 * @return The default deployment for the supplied test element, or <code>null</code> if
	 * there is no default deployment for this element. The returned element must be one
	 * of the elements returned by getDeployments(Object).
	 */
	public TPFDeployment getDefaultDeployment(Object testElement);
	
}
