/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IExecutionHistoryDefaultsProvider.java,v 1.4 2005/02/16 22:22:13 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.launch.extensions;

import org.eclipse.core.resources.IContainer;

/**
 * This interface is to be implemented by plugins extending the
 * org.eclipse.hyades.test.ui.executionHistoryDefaults extension point.
 * @author jcanches
 */
public interface IExecutionHistoryDefaultsProvider {
	
	/**
	 * Returns the default name for the given testElement.
	 * @param testElement an instance of a runnable entity. This may be an instance of
	 * TPFTest or of TPFTestComponent.
	 * @return The default name for the execution history produced by the execution
	 * of the supplied element.
	 */
	String getDefaultName(Object testElement);
	
	/**
	 * Return the default state for the "Override" check box for the given testElement.
	 * Hyades default is false.<br>
	 * State false means that an existing resource with the supplied name will not be
	 * overwritten if it already exists. In that case, a unique name will be generated,
	 * starting with the supplied name.
	 * @param testElement
	 * @return false for leaving the check box unchecked, true otherwise.
	 */
	boolean getDefaultOverrideState(Object testElement);
	
	/**
	 * Returns the default location for the given testElement.
	 * @param testElement an instance of a runnable entity. This may be an instance of
	 * TPFTest or of TPFTestComponent.
	 * @return The default location for the execution history produced by the execution
	 * of the supplied element. This should be an instance of a Workspace Project or Folder.
	 */
	IContainer getDefaultLocation(Object testElement);
	
}
