/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IExecutionResultsLocationFilter.java,v 1.3 2005/02/16 22:22:13 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.launch.extensions;

import org.eclipse.core.resources.IContainer;

/**
 * This interface must be implemented by contributors to the extension
 * point executionResultsLocationFilter. It allows to specify whether
 * a certain location should be proposed as a container for execution
 * results or not.
 * @author jcanches
 */
public interface IExecutionResultsLocationFilter {
	
	/**
	 * Returns true if the specified location should not be displayed
	 * in the available locations in the "Execution Results" tab of a
	 * Hyades Launch Configuration. Note that the return value of this method
	 * should be always the same for a given configuration.
	 * @param location
	 * @return
	 */
	boolean isFiltered(IContainer location);

}
