/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: BasicTestComponentTabGroup.java,v 1.5 2005/02/16 22:22:13 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.launch.tabGroups;

import java.util.List;

/**
 * This class provides the TabGroup for the basic Hyades Test Component Launch Configurations.
 * It consists of a Test Component Selection Tab, plus the standard Hyades Tabs ([Profiling],
 * Test Execution History, Common).
 * Sub-classes may add additional tabs after the Test Component Selection Tab by overriding
 * the method <code>addAdditionalTabs(List tabList)</code>.
 * @see org.eclipse.hyades.test.ui.launch.tabGroups.AbstractTabGroup
 * @author jcanches
 */
public class BasicTestComponentTabGroup extends AbstractTabGroup {

	/**
	 * Add to the tab list the Hyades Test Component Selection Tab.
	 * @param tabList
	 */
	protected void addRunnableItemSelectionTab(List tabList, String mode) {
		addTestComponentAndDeploymentTab(tabList, mode);
	}
	
	protected void addAdditionalTabs(List tabList, String mode) {
		// The basic Launch Configuration does not provide additional tabs.
	}
	
	protected String getLaunchConfigurationType() {
		return null; // means use basic Launch Configuration Type
	}
}
