/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TypedElementProxyNode.java,v 1.3 2005/02/16 22:22:14 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.navigator;

import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestComponent;
import org.eclipse.hyades.test.ui.TestUIConstants;
import org.eclipse.ui.IMemento;

/** General proxy for typed element. 
 *  This class is derived for test suite, test case, test component and execution result
 * @author jgout
 */
public abstract class TypedElementProxyNode extends CMNNamedElementProxyNode implements ITypedElementProxyNode {
	private String type; 
	
	public TypedElementProxyNode(TPFTest test, Object parent) {
		super(test, parent);
		type = test.getType();
	}
	
	public TypedElementProxyNode(TPFExecutionResult exec, Object parent) {
		super(exec, parent);
		type = exec.getType();
	}
	
	public TypedElementProxyNode(TPFTestComponent testComponent, Object parent) {
		super(testComponent, parent);
		type = testComponent.getType();
	}
	
	public TypedElementProxyNode(IMemento memento, Object parent) {
		super(memento, parent);
		this.type = memento.getString(TestUIConstants.TAG_TYPE);
		if (this.type == null) {
			throw new IllegalArgumentException("Malformed saved proxy state: unable to retrieve type field"); //$NON-NLS-1$
		}
	}
	
	public String getType() {
		return type;
	}
	
}
