/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SecurityUI.java,v 1.6 2005/02/16 22:21:33 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.security.util;

import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.*;

import org.eclipse.hyades.execution.security.KeystoreHelper;
import org.eclipse.hyades.security.SecurityPlugin;

public class SecurityUI implements Listener
{
    private Shell fShell;
	private Text  txtPath;
	private Text  txtName;
    private String fAlias;
    private String fType;
    private String fPath;
    private ArrayList listenerList;
	
	private Button btnBrowse;
	
	public SecurityUI(Shell shell){
        fShell = shell;
        listenerList = new ArrayList();			
	}
	
	
	public void createContents(Composite c){ 

            GridData data;
			Composite nameGroup = new Composite(c, SWT.NONE);
			GridLayout layout = new GridLayout();
			layout.numColumns = 3;
			data = GridUtil.createFill();
			data.widthHint = 400;
			nameGroup.setLayoutData(data);
			nameGroup.setLayout(layout);
			
			Label lblPath = new Label(nameGroup, SWT.NONE);
			lblPath.setText(SecurityPlugin.getResourceString("STR_CERTIFICATE_FILE"));
			txtPath = new Text(nameGroup, SWT.BORDER);				
			txtPath.setLayoutData(GridUtil.createHorizontalFill());
			txtPath.setText("");
			
			btnBrowse = new Button(nameGroup, SWT.PUSH);
			btnBrowse.setText(SecurityPlugin.getResourceString("STR_BROWSE"));
			
			btnBrowse.addListener(SWT.Selection, this);

			Label lblName = new Label(nameGroup, SWT.NONE);
			lblName.setText(SecurityPlugin.getResourceString("STR_CERTIFICATE_ALIAS"));
			txtName = new Text(nameGroup, SWT.BORDER);
			txtName.setText("");

			txtName.setLayoutData(GridUtil.createHorizontalFill());
						
			txtName.addListener(SWT.Modify, this);
			txtPath.addListener(SWT.Modify, this);

	}

	/**
	 *  Handle all events and enablements for widgets in this dialog
	 *
	 * @param event Event
	 */
	public void handleEvent(Event event) {

		if(event.widget == btnBrowse){
			showFileDialog();
			NotifyListeners(event);
		}
		if(event.widget==txtName || event.widget==txtPath){
			//setButtonState();
			fPath = txtPath.getText();
			fAlias = txtName.getText();
			NotifyListeners(event);			
		}

	}
	
	public void NotifyListeners(Event event){
		for(int i=0;i<listenerList.size();i++){
			((Listener)listenerList.get(i)).handleEvent(event);
		}	
	}
	
	public boolean validateDialog(){
		return (txtName.getText().trim().length()>0 && txtPath.getText().trim().length()>0);
	}
	
	private void setButtonState(){
		fShell.getDefaultButton().setEnabled(validateDialog());
	}
	
	private void showFileDialog(){
		String currentSource = txtPath.getText();

		FileDialog dlg = new FileDialog(fShell, SWT.OPEN);
		
		dlg.setFileName(currentSource);
		dlg.setFilterExtensions(new String[]{"*.cer", "*.*"});
		
		String source = dlg.open();

		if(source!=null){
			txtPath.setText(source);
		}
			
	}

	public Certificate loadCertificate(KeyStore ks) throws IOException, CertificateException, KeyStoreException {

			
		Certificate fCertificate = KeystoreHelper.loadCertificate(getPath());
		KeystoreHelper.addCertificateToKeyStore(ks, fCertificate, getAliasName());
		return fCertificate;

	}		

	public void registerListener(Listener listener){
		listenerList.add(listener);
		
	}
    public String getAliasName()
    {
    	return fAlias;
    }
    
    public String getPath()
    {
    	return fPath;
    }
 
}
