/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: HttpRecorderAgentEnvironmentAdapter.java,v 1.7 2005/04/22 14:51:05 bjiang Exp $
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.recorder.http.local;

import java.io.IOException;

import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.execution.recorder.http.HttpRecorderPlugin;
import org.eclipse.hyades.internal.execution.recorder.remote.RecorderEnvironmentAdapter;

/**
 * This object is used to prepare the Agent Controller execution environment for the HTTP recorder.  
 * @author Ernest Jessee
 */
public class HttpRecorderAgentEnvironmentAdapter extends RecorderEnvironmentAdapter
{

	
	/**
	 * this method is called to acquire classpath appendages.  Since the http recorder remote jars are 
	 * installed with the Agent Controller and are on the Agent Controller's classpath, we do not have to modify the classpath here.  
	 * We could add directories and/or jars at this point by returned a semi-colon delimeted String of classpath
	 * which ends with a semi-colon
	 * entries
	 * For example:
	 * String jarPath = null;
	 * 	try
	 * 	{
	 * 		jarPath= Platform.resolve(HttpRecorderPlugin.getDefault().getBundle().getEntry("/")).getPath();
	 * 		jarPath+="bin;";
	 * 	}
	 * 	catch (IOException e)
	 * 	{
	 *		e.printStackTrace();
	 *	}
	 *	return jarPath;
	 * 
	 */
	protected String getClassPathEntry()
	{
		String jarPath = null;
	  	try
	  	{
	  		jarPath= Platform.resolve(HttpRecorderPlugin.getDefault().getBundle().getEntry("/")).getPath();
	  		jarPath+="bin;";
	  	}
	  	catch (IOException e)
	  	{
	 		e.printStackTrace();
	 	}
	 	return jarPath;
		
	}

}
