/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: HttpRecorderDataProcessor.java,v 1.14 2005/02/16 22:20:21 qiyanli Exp $
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.recorder.http.local;

//import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.hyades.execution.recorder.RecorderPlugin;
import org.eclipse.hyades.execution.recorder.http.HttpRecorderPlugin;
import org.eclipse.hyades.execution.recorder.http.remote.ClientSideReader;
import org.eclipse.hyades.execution.recorder.http.remote.SSLProxyRecorder;
import org.eclipse.hyades.internal.execution.recorder.local.IRecorderDataProcessor;
import org.eclipse.hyades.internal.execution.recorder.utilities.RecorderFileUtil;



/**
 * This object accepts data passed across the Agent Controller data channel from the RecorderAgent(SSLProxyRecorder)
 * @author Ernest Jessee
 */
public class HttpRecorderDataProcessor implements IRecorderDataProcessor
{
	
	/**
	 * the file in which to store the trace
	 */
	private IFile traceFile = null;
	
	private java.io.File javaTraceFile = null;
	
	private boolean sslWarningShown=false;



	/**
	 * called to initialize the IRecorderDataProcessor.  This is where the storage file is created and initialized
	 */
	public void initialize() throws IOException
	{
		String fileName = HttpRecorderPlugin.getPreference(HttpRecorderPlugin.RECORDING_PATH);
		
		try
		{
			traceFile = RecorderFileUtil.createTraceFile(fileName);
			javaTraceFile = traceFile.getRawLocation().toFile();
			if (!javaTraceFile.exists())
				throw new IOException(HttpRecorderPlugin.getResourceString("HttpRecorderDataProcessor.UNABLE_TO_CREATE_TRACE_FILE_ERROR")); //$NON-NLS-1$

		}
		catch (CoreException e)
		{
			throw new IOException(HttpRecorderPlugin.getResourceString("HttpRecorderDataProcessor.UNABLE_TO_CREATE_TRACE_FILE_ERROR")+e.getMessage()); //$NON-NLS-1$
		}		
		
		RecorderFileUtil.createTraceModel(fileName, traceFile.getFullPath().toString());		
	}

	
	/**
	 * called by the recorder when the recording session is complete
	 */
	public void complete()
	{		
		try {
			if (traceFile != null)
				traceFile.refreshLocal(IFile.DEPTH_ZERO, new NullProgressMonitor());
		}
		catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * This method is called with valid data
	 */
	synchronized public void processData(byte[] data)
	{		
		try
		{
			//ByteArrayInputStream bais = new ByteArrayInputStream(data);			
			//traceFile.appendContents(bais, IFile.FORCE , new NullProgressMonitor());		

			//Problem with IBM JDK 1.4.1 - NullProgressMonitors causes multiple SWT nested NPE's
			//not corrected if changed to null. For now, append to file manually & be sure to close the file's stream
			
			FileOutputStream outStream = new FileOutputStream(javaTraceFile, true);
			//TODO jn?: Improve file i/o performance
			outStream.write(data);
			outStream.flush();
			outStream.close();
		}
		catch (Exception e) //(CoreException e)
		{
			e.printStackTrace();
		}

	}

	
	/**
	 * this method is called with control strings
	 */
	public void processControlString(String controlString)
	{
		if(controlString.startsWith(ClientSideReader.ERROR_SSL_REQUEST_MADE) && !sslWarningShown)
		{
			StringTokenizer errorTokenizer = new StringTokenizer(controlString,",");
			RecorderPlugin.reportExceptionToUser(new Exception(HttpRecorderPlugin.getResourceString("HttpRecorderDataProcessor.SSL_RECORDER_ATTEMPTED_ERR_MESSAGE")),HttpRecorderPlugin.getResourceString("HttpRecorderDataProcessor.PLAYBACK_MAY_BE_AFFECTED_WARNING"),HttpRecorderPlugin.getResourceString("HttpRecorderDataProcessor.SSL_PACKET_IN_RECORDING_AND_NOT_SUPPORTED_WARNING"),HttpRecorderPlugin.getResourceString("HttpRecorderDataProcessor.WARNING")); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
			sslWarningShown=true;		
		}
		else if(controlString.startsWith(ClientSideReader.ERROR_NO_TESTKEYS) && !sslWarningShown)
		{
			RecorderPlugin.reportExceptionToUser(new Exception(HttpRecorderPlugin.getResourceString("HttpRecorderDataProcessor.SSL_RECORDER_ATTEMPTED_ERR_MESSAGE")),HttpRecorderPlugin.getResourceString("HttpRecorderDataProcessor.PLAYBACK_MAY_BE_AFFECTED_WARNING"),HttpRecorderPlugin.getResourceString("HttpRecorderDataProcessor.TESTKEYS_NOT_FOUND"),HttpRecorderPlugin.getResourceString("HttpRecorderDataProcessor.WARNING")); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
			sslWarningShown=true;		
		} 
		else if(controlString.startsWith(SSLProxyRecorder.ERROR_CREATING_CLIENTSIDEREADER) && !sslWarningShown)
		{
			RecorderPlugin.reportExceptionToUser(new Exception(HttpRecorderPlugin.getResourceString("HttpRecorderDataProcessor.PROBLEM_CREATING_CLIENTSIDEREADER")),
					HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.UNABLE_TO_START_RECORDER_MESSAGE"),
					HttpRecorderPlugin.getResourceString("HttpRecorderDataProcessor.PROBLEM_CREATING_CLIENTSIDEREADER"),
					HttpRecorderPlugin.getResourceString("HttpRecorderDataProcessor.SOCKET_BIND_ERROR")); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
			sslWarningShown=true;		
		}
	}

	/**
	 * this method is called with debug Strings
	 */
	public void processDebugString(String debugString)
	{
		System.out.println(debugString);

	}

}
