/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: HttpRecorderFileSelectPage.java,v 1.5 2005/02/16 22:20:26 qiyanli Exp $
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.recorder.http.ui.wizards;

import org.eclipse.hyades.execution.recorder.http.HttpRecorderPlugin;
import org.eclipse.hyades.internal.execution.testgen.ui.wizards.FileLocationSelectionWizardpage;

/**
 * Wizard page for specifying the filename and path for the recorded trace
 * @see org.eclipse.hyades.internal.execution.testgen.ui.wizards.FileLocationSelectionWizardpage
 * @author Ernest Jessee
 */
public class HttpRecorderFileSelectPage extends FileLocationSelectionWizardpage
{

	/**
	 * 
	 */
	public HttpRecorderFileSelectPage() {
		super();
	}

	public String getDescription()
	{
		return HttpRecorderPlugin.getResourceString("HttpRecorderFileSelectPage.SELECT_RECORDING_FILE_LOCATION_WIZARDPAGE_DESCRIPTION"); //$NON-NLS-1$
	}

	
	public String getFileExtension()
	{
		return "rec"; //$NON-NLS-1$
	}

	
	public String getFileNameLabel()
	{
		return HttpRecorderPlugin.getResourceString("HttpRecorderFileSelectPage.SELECT_RECORDING_FILE_LOCATION_WIZARDPAGE_FILENAME_LABEL"); //$NON-NLS-1$
	}

	
	
	public String getTitle()
	{
		return HttpRecorderPlugin.getResourceString("HttpRecorderFileSelectPage.SELECT_RECORDING_FILE_LOCATION_WIZARDPAGE_TITLE"); //$NON-NLS-1$
	}

	
	public String getContextHelpID()
	{
		return "org.eclipse.hyades.execution.recorder.http.RecordingLocationSelector"; //$NON-NLS-1$
	}
}
