/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IViewSelectionChangedListener.java,v 1.4 2005/02/16 22:23:46 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui;

/**
 * A problem determination view event listener registers with the hyades ui plug-in
 * to receive event notification when selection changes in hyades views
 * <p>
 * Clients may implement this interface.
 * </p>
 */
public interface IViewSelectionChangedListener {
	
	/**
	 * Notifies that the selection has changed.
	 *
	 * @param event event object describing the change
	 */
	public void handleViewSelectionChangedEvent(ViewSelectionChangedEvent event);
}
