/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TraceViewerPage.java,v 1.5 2005/02/16 22:23:47 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.part.Page;

public abstract class TraceViewerPage extends Page {
	protected TraceViewer _viewer;
	protected EObject _mofObject;
	protected Menu fContextMenu;

	/**
	 */
	public TraceViewerPage(EObject mofObject, TraceViewer viewer) {
		super();

		_viewer = viewer;
		_viewer.initializeActionBar();
		_mofObject = mofObject;
	}
	public EObject getMOFObject() {
		return _mofObject;
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (1/11/2001 2:19:36 PM)
	 * @return com.ibm.etools.trace.adapter.TraceViewer
	 */
	public TraceViewer getTraceViewer() {
		return _viewer;
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (6/5/2001 2:45:25 PM)
	 */
	public abstract void refreshPage();
	/**
	 * Insert the method's description here.
	 * Creation date: (6/5/2001 2:45:25 PM)
	 */
	public abstract void selectionChanged();

	/**
	 * Insert the method's description here.
	 * Creation date: (2/19/2001 1:29:52 PM)
	 * @param object com.ibm.etools.emf.ref.RefBaseObject
	 */
	public void setMofObject(EObject object) {
		_mofObject = object;
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (08/14/2000 5:50:25 PM)
	 */
	public abstract void update(boolean newPage);

	/**
	 * Contribute to the view popup menu
	 * @param menu
	 */
	public void fillContextMenu(IMenuManager menu) {
	}
	
	/**
	 * Set the context menu for this view page
	 * @param parent
	 */
	public void setContextMenu(Control parent, ISelectionProvider selProvider)
	{
		if(parent == null || parent.isDisposed())
		  return;
		  
		MenuManager menuMgr= new MenuManager("#PopupMenu"); //$NON-NLS-1$
		menuMgr.setRemoveAllWhenShown(true);
		menuMgr.addMenuListener(_viewer);
		fContextMenu= menuMgr.createContextMenu(parent);
		parent.setMenu(fContextMenu);
	
		// Register viewer with site. This must be done before making the actions.
		IWorkbenchPartSite site= _viewer.getSite();
		site.registerContextMenu(menuMgr, selProvider);
		site.setSelectionProvider(selProvider);
		  
	}
	
	public void dispose()
	{
		super.dispose();
		
		_mofObject = null;  
		
		if(fContextMenu != null)
		   fContextMenu.dispose();
	   

	}
	
	public boolean isEmpty()
	{
		//assume page is not empty
		return false;
	}

}
