/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ViewSelectionChangedEvent.java,v 1.6 2005/02/16 22:23:47 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui;

/**
 * A PDViewEvent is sent when the selection changes in one of the problem determination views 
 * <p>
 * The <code>getSource()</code> source of the selection event
 * returns the element associated with the event.
 * </p>
 */
public final class ViewSelectionChangedEvent {
	
	private Object source;
	
	public ViewSelectionChangedEvent() {
	}
					
	public Object getSource()
	{
		return source;
	}
	
	public void setSource(Object eventSource)
	{
		source = eventSource;
	}
}

