/**********************************************************************
 * Copyright (c) 2005 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.ui.filters;

import org.eclipse.hyades.trace.ui.filters.internal.actions.FiltersSelectionAction;
import org.eclipse.hyades.trace.ui.filters.internal.util.FilterInformationManager;
import org.eclipse.jface.action.IAction;

public class FilterActions {
	
	/**
	 * 
	 * @param IFilterViewer The viewer that the action to be returned is associated with. 
	 * @return The filters drop down action associated with the given
	 * IFilterViewer instance.
	 */	
	public static IAction getFiltersSelectionAction(IFilterViewer filterViewer)
	{
		return new FiltersSelectionAction(FilterInformationManager.instance(filterViewer));
	}
}
