/**********************************************************************
 * Copyright (c) 2005 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.filters;

import org.eclipse.hyades.models.hierarchy.extensions.WhereExpression;


/**
*
* Encapsulates an EStructuralFeature with a text description that will
* be displayable in the advanced tab of the filters dialog.  The EStructuralFeature
* is the feature we can filter by. 
*/
public interface IFilterAttribute {
	public String id();
	public String displayText();
	public String validate(String operator, String value);
	public String[] operators();
	public WhereExpression getWhereExpression(String operator, String value);
	public String getValue(WhereExpression whereExpression);
	public String getOperator(WhereExpression whereExpression);
	
	public String defaultValue();
}
