/**********************************************************************
 * Copyright (c) 2005 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.filters.internal.actions;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.filters.internal.util.FilterInformationManager;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;


public class FiltersSelectionAction extends Action {

	private FiltersEditorAction _feAction;	
	private FiltersDropDownMenu _fddm;
	private FilterInformationManager _fi;
	
	public FiltersSelectionAction(FilterInformationManager fi) {
		super("");

		_fi = fi;
		_feAction = new FiltersEditorAction(_fi);
		_fddm = new FiltersDropDownMenu(_fi);
		setMenuCreator(_fddm);
		
		PDPluginImages.setImageDescriptors(this, PDPluginImages.T_LCL, PDPluginImages.IMG_VIEW_FILTER);
		
		setEnabled(true);		
	}
	
	
	public void run() {
		CreateOrEditFilter.run(_fi, 0, null, null, -1);
	}
	
	
	
	public void run(IAction action) {
		run();
	}
	
	public void setInitializationData(
		IConfigurationElement configElement,
		String name,
		Object data) {
	}
	
	public void selectionChanged(IAction action, ISelection selection) {
	}

	public void dispose() {
	}

	public void init(IWorkbenchWindow window) {
	}
	
	public void init(IViewPart view) {
	}
}	

