/**********************************************************************
 * Copyright (c) 2005 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.filters.internal.actions;

import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;

public class FiltersSetAction extends Action {
	
	private FiltersDropDownMenu _menu;
	private String _filterName;
	
	/**
	 * 
	 */
	public FiltersSetAction(FiltersDropDownMenu menu, String filterName, ImageDescriptor imageDescriptor) {
		super(filterName, IAction.AS_RADIO_BUTTON);
		_menu = menu;
		
		if (!UIPlugin.getResourceString("STR_DROPDOWN_NO_FILTER").equals(filterName))
			_filterName = filterName;
		else
			_filterName = null;
		
		if (imageDescriptor != null)
			setImageDescriptor(imageDescriptor);
		
		//setText(_filterName);
	}
	
	public void run() {
		if (isChecked())
			_menu.selectedFilterName(_filterName);
	}
	
	public void run(IAction action) {
		run();
	}
	
}
