/**********************************************************************
 * Copyright (c) 2005 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.ui.filters.internal.dialogs;

import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.filters.internal.util.FilterInformationManager;
import org.eclipse.hyades.trace.ui.internal.filters.IFilterType;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.model.WorkbenchViewerSorter;

public class FilterTypeDialog extends Dialog {

	
	public class FilterTypeLabelProvider extends LabelProvider
	{
		public String getText(Object element)
		{
			return ((IFilterType)element).name();
		}
		
		public Image getImage(Object element) {
			ImageDescriptor icon = ((IFilterType)element).icon(); 
			if (icon != null)
				return icon.createImage();
			else
				return null;
		}		
		
		public void dispose() {
		}
		
	}
	
	public class FilterTypeContentProvider implements IStructuredContentProvider
	{
		/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.IStructuredContentProvider#getElements(java.lang.Object)
		 */
		public Object[] getElements(Object inputElement) {
			if (_fi != null && _fi == inputElement) {
				return _fi.getFilterTypes();
			}
			return new Object[0];			
		}

		/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.IContentProvider#dispose()
		 */
		public void dispose() {
		}

		/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.IContentProvider#inputChanged(org.eclipse.jface.viewers.Viewer, java.lang.Object, java.lang.Object)
		 */
		public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		}
		
	}	
	
	private TableViewer _typeListViewer;	
	
	private FilterInformationManager _fi;
	
	private IFilterType _selectedFilterType;
	
	
	protected FilterTypeDialog(FilterInformationManager fi) {
		super(Display.getDefault().getActiveShell());
		
		_fi = fi;
	}
	
	protected Control createDialogArea(Composite parent)
	{
		getShell().setText(UIPlugin.getResourceString("EDIT_FILTERS_DIALOG_TITLE"));
		
		Composite composite = (Composite) super.createDialogArea(parent);

		createMessageLabel(composite);
		
		Composite listComposite = new Composite(composite, SWT.NULL);
		GridLayout layout;
		layout = new GridLayout();
		layout.numColumns = 2;
		listComposite.setLayout(layout);		
		
		_typeListViewer = new TableViewer(listComposite, SWT.BORDER | SWT.MULTI);
		GridData data = new GridData(GridData.HORIZONTAL_ALIGN_FILL);
		data.grabExcessHorizontalSpace = true;
		data.heightHint = 200;
		data.widthHint = 200;
		_typeListViewer.getTable().setLayoutData(data);		
		_typeListViewer.getTable().addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
			}
		});		
		
		_typeListViewer.setLabelProvider(new FilterTypeLabelProvider());
		_typeListViewer.setContentProvider(new FilterTypeContentProvider());
		_typeListViewer.setSorter(new WorkbenchViewerSorter());
		_typeListViewer.addSelectionChangedListener(new ISelectionChangedListener() {
			public void selectionChanged(SelectionChangedEvent event) {
				//handleSelectionChanged();
			}
		});
		_typeListViewer.addDoubleClickListener(new IDoubleClickListener() {
			public void doubleClick(DoubleClickEvent event) {
				//edit action?
			}
		});
		
		_typeListViewer.setInput(_fi);
		_typeListViewer.setSorter(null);
		_typeListViewer.refresh();
		
		setInitialSelection();
		
		return composite;
	}
	
	private Label createMessageLabel(Composite composite) {
		Label label = new Label(composite, SWT.NONE);
		label.setText(UIPlugin.getResourceString("ADD_FILTERS_TYPE_MESSAGE"));
		return label;
	}
	
	protected void selectTableItem(Table table, int selection) {
		table.setFocus();
		table.setSelection(selection);
		table.showSelection();
	}		
	
	private void setInitialSelection()
	{
		selectTableItem(_typeListViewer.getTable(), 0);		
	}

	protected void okPressed() {
		int selection = _typeListViewer.getTable().getSelectionIndex();
		
		super.okPressed();
		
		_selectedFilterType = _fi.getFilterTypes()[selection];
	}
	
	protected void cancelPressed()
	{
		super.cancelPressed();
		
		_selectedFilterType = null;
	}
	
	public IFilterType selectedFilterType()
	{
		return _selectedFilterType;
	}
}
