/**********************************************************************
 * Copyright (c) 2005 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.ui.filters.internal.dialogs;

import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsFactory;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalExpression;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.models.hierarchy.extensions.WhereExpression;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.filters.IAdvancedTabAttributeSet;
import org.eclipse.hyades.trace.ui.filters.IFilterAttribute;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class FiltersAdvancedUI extends FiltersTabUI {

	//private static String OR_SEPARATOR = "|";
	
	public class FilterSetLabelProvider extends LabelProvider implements ITableLabelProvider
	{
		/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.ITableLabelProvider#getColumnImage(java.lang.Object, int)
		 */
		public Image getColumnImage(Object element, int columnIndex) {
			return null;
		}

		/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.ITableLabelProvider#getColumnText(java.lang.Object, int)
		 */
		public String getColumnText(Object element, int columnIndex) {
			FilterElement fe = (FilterElement)element;
			
			if (columnIndex == 0)
				return fe.attribute().displayText();
			else if (columnIndex == 1)
				return fe.operator();
			else if (columnIndex == 2)
				return fe.value();
			
			return null;
		}

		/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.IBaseLabelProvider#dispose()
		 */
		public void dispose() {
		}
	}
	
	public class FilterSetContentProvider implements IStructuredContentProvider
	{
		/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.IStructuredContentProvider#getElements(java.lang.Object)
		 */
		public Object[] getElements(Object inputElement) {
			if (_filterElementSet != null) {
				return _filterElementSet.toArray();
			}
			return new Object[0];		

		}

		/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.IContentProvider#dispose()
		 */
		public void dispose() {
		}

		/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.IContentProvider#inputChanged(org.eclipse.jface.viewers.Viewer, java.lang.Object, java.lang.Object)
		 */
		public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		}
		
	}	
	

	class EditDialog extends Dialog{
		private IFilterAttribute _attribute;
		private String _operator;
		private String _value;
		private Combo _AttributeText;
		private Combo _OperatorText;
		private Text _ValueText;
		private String _title;

		public EditDialog(
			Shell shell,
			String title,
			IFilterAttribute attribute,
			String operator,
			String value) {
			super(shell);

			_attribute = attribute;
			_operator = operator;
			_value = value;
			_title = title;
		}

		protected void configureShell(Shell shell) {
			super.configureShell(shell);
			shell.setText(_title);
		}

		public IFilterAttribute attribute() {
			return _attribute;
		}

		public String operator() {
			return _operator;
		}

		public String value() {
			return _value;
		}
		
		private void attributeUpdate(IFilterAttribute attribute)
		{
			_ValueText.setText(attribute.defaultValue());
			
			_OperatorText.removeAll();
			String [] operators = attribute.operators();
			for (int i=0;i<operators.length;i++)
			{
				_OperatorText.add(operators[i]);	
			}			
			
			_OperatorText.select(0);			
		}

		protected Control createDialogArea(Composite parent) {
			Composite result = (Composite) super.createDialogArea(parent);

			GridLayout layout;
			GridData data;
			Label label;

			layout = new GridLayout();
			layout.numColumns = 2;
			result.setLayout(layout);
			data = GridUtil.createFill();
			data.widthHint = 400;
			result.setLayoutData(data);

			label = new Label(result, SWT.NULL);
			label.setText(UIPlugin.getResourceString("HEADER_ATTRIBUTE"));
			_AttributeText = new Combo(result, SWT.BORDER | SWT.READ_ONLY);
			_AttributeText.setLayoutData(GridUtil.createHorizontalFill());
			_AttributeText.addSelectionListener(new SelectionAdapter() {
				public void widgetSelected(SelectionEvent e) {
					attributeUpdate(getAttributeFromString(_AttributeText.getText().trim()));
				}
			});
			
			for (int i=0;i<_attributes.length;i++)
			{
				_AttributeText.add(_attributes[i].displayText());	
			}
			
			label = new Label(result, SWT.NULL);
			label.setText(UIPlugin.getResourceString("HEADER_OPERATOR"));
			_OperatorText = new Combo(result, SWT.BORDER | SWT.READ_ONLY);
			_OperatorText.setLayoutData(GridUtil.createHorizontalFill());

			label = new Label(result, SWT.NULL);
			label.setText(UIPlugin.getResourceString("HEADER_VALUE"));
			_ValueText = new Text(result, SWT.BORDER);
			_ValueText.setLayoutData(GridUtil.createHorizontalFill());

			_AttributeText.select(0);
			//_OperatorText.select(0);

			if (_attribute != null)
				_AttributeText.setText(_attribute.displayText());
			
			attributeUpdate(getAttributeFromString(_AttributeText.getText().trim()));

			if (_operator != null)
				_OperatorText.setText(_operator);
			
			if (_value != null)
				_ValueText.setText(_value);			

			_AttributeText.setFocus();
			setContextHelpId(result);

			return result;
		}


		protected void okPressed() {
			_attribute = getAttributeFromString(_AttributeText.getText().trim());
			_operator = _OperatorText.getText();
			_value = _ValueText.getText();
			super.okPressed();
		}
		
		private void setContextHelpId(Control control){
			/*switch(iType){
				case LogUIConstants.FILTER_LOG_VIEW:
				{
			
					WorkbenchHelp.setHelp(control, ContextIds.ACTLOG_VIEW_DIALOG_FILTER);
					break;
				}
				case LogUIConstants.FILTER_LOG_INTER:
				{
					WorkbenchHelp.setHelp(control, ContextIds.LOGINTER_VIEW_DIALOG_FILTER);
					break;
				}
				case LogUIConstants.SEARCH:
				{
					WorkbenchHelp.setHelp(control, ContextIds.ACTLOG_VIEW_DIALOG_SEARCH);						
				}
			
			}*/
		}
		
	}

	private Table _table; 
	
	//private Button _upBtn;
	//private Button _downBtn;
	private Button _addBtn;
	private Button _editBtn;
	private Button _removeBtn;
	
	private Composite result;
	private CheckboxTableViewer _tableViewer;

	public static IFilterAttribute[] _attributes;
	
	private FilterElementSet _filterElementSet;
	
	
	protected FiltersAdvancedUI(IAdvancedTabAttributeSet attributes)
	{
		_attributes = attributes.getAttributes();
	}
	
	public Control createControl(Composite parent) {
		GridData data;
		GridLayout layout;
	
		result = new Composite(parent, SWT.NULL);
		layout = new GridLayout();
		layout.numColumns = 2;
		layout.verticalSpacing = 0;
		result.setLayout(layout);
		data = GridUtil.createFill();
		//data = new GridData();
		result.setLayoutData(data);
	
		Label _contentLabel = new Label(result, SWT.NULL);
		_contentLabel.setText(UIPlugin.getResourceString("ADVANCE_FILTERS_LABEL"));
		data = new GridData();
		//data = GridUtil.createFill();		
		data.horizontalSpan = 2;
		_contentLabel.setLayoutData(data);				
	
		Composite tableGroup = new Composite(result, SWT.NULL);
		layout = new GridLayout();
		layout.numColumns = 1;
		tableGroup.setLayout(layout);
		data = new GridData();
		data.heightHint = 250;
		data.widthHint = 400;
		//data = GridUtil.createFill();
		tableGroup.setLayoutData(data);
		initializeTable(tableGroup);
	
		Composite btnGroup = new Composite(result, SWT.NULL);
		layout = new GridLayout();
		layout.numColumns = 1;
		btnGroup.setLayout(layout);
		btnGroup.setLayoutData(GridUtil.createVerticalFill());
	
		Composite addGroup = new Composite(btnGroup, SWT.NULL);
		layout = new GridLayout();
		layout.numColumns = 1;
		layout.makeColumnsEqualWidth = true;
		addGroup.setLayout(layout);
		addGroup.setLayoutData(GridUtil.createVerticalFill());
	
		_addBtn = createModifyButton(addGroup, UIPlugin.getResourceString("ADD_FILTER_BTN"), UIPlugin.getResourceString("ADD_FILTER__BTN_TOOLTIP_TEXT"));
		_addBtn.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				addButtonPressed();
			}
		});
		
		_editBtn = createModifyButton(addGroup, UIPlugin.getResourceString("EDIT_FILTER_BTN"), UIPlugin.getResourceString("EDIT_FILTER_BTN_TOOLTIP_TEXT"));
		_editBtn.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				editButtonPressed();
			}
		});
		
		_removeBtn = createModifyButton(addGroup, UIPlugin.getResourceString("REMOVE_FILTER_BTN"), UIPlugin.getResourceString("REMOVE_FILTER_BTN_TOOLTIP_TEXT"));
		_removeBtn.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				removeButtonPressed();
			}
		});
		
	
		Composite moveGroup = new Composite(btnGroup, SWT.NULL);
		layout = new GridLayout();
		layout.numColumns = 1;
		layout.makeColumnsEqualWidth = true;
		moveGroup.setLayout(layout);
		moveGroup.setLayoutData(GridUtil.createHorizontalFill());
	
/*		_upBtn = createModifyButton(moveGroup, UIPlugin.getResourceString("MOVEUP_TEXT"), UIPlugin.getResourceString("MOVEUP_TOOLTIP_TEXT"));
		_upBtn.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				upButtonPressed();
			}
		});
		
		_downBtn = createModifyButton(moveGroup, UIPlugin.getResourceString("MOVEDOWN_TEXT"), UIPlugin.getResourceString("MOVEDOWN_TOOLTIP_TEXT"));
		_downBtn.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				downButtonPressed();
			}
		});
*/		
	
		_editBtn.setEnabled(false);
		_removeBtn.setEnabled(false);
		//_upBtn.setEnabled(false);
		//_downBtn.setEnabled(false);
		
		//setContextHelpIds();
		
		return result;
	}
	
	private Button createModifyButton(Composite parent, String text, String toolTipText)
	{
		Button button = new Button(parent, SWT.PUSH);
		button.setText(text);
		button.setToolTipText(toolTipText);
		button.setLayoutData(GridUtil.createHorizontalFill());
		
		return button;
	}	
	
	protected void initializeTable(Composite parent) {
		createTable(parent);
		_tableViewer = new CheckboxTableViewer(_table);
		createColumns();
	
		_tableViewer.setContentProvider(new FilterSetContentProvider());
		_tableViewer.setLabelProvider(new FilterSetLabelProvider());
	
		//_filterList = new FilterList(_tableViewer);
		_tableViewer.setInput(new Object());
	
	/*	CellEditor editors[] = new CellEditor[_table.getColumnCount()];
	
		editors[0] = new ComboBoxCellEditor(_table, _attributes);
		editors[1] = new ComboBoxCellEditor(_table, _operators);
		editors[2] = new TextCellEditor(_table);
	
		_tableViewer.setCellEditors(editors);
	
		FilterElementModifier modifier = new FilterElementModifier(_tableViewer);
		_tableViewer.setCellModifier(modifier);
		_tableViewer.setColumnProperties(tableColumnProperties);
		*/

	}

	private void createTable(Composite parent) {
		_table = new Table(
						parent,
						SWT.H_SCROLL
						| SWT.V_SCROLL
						| SWT.BORDER
						| SWT.MULTI
						| SWT.FULL_SELECTION);
		_table.setLinesVisible(true);
		_table.setLayoutData(GridUtil.createFill());
		
		_table.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				tableSelect();
			}
		});
	}
	
	private void createColumns() {
		TableLayout layout = new TableLayout();
		_table.setLayout(layout);
		_table.setHeaderVisible(true);
	
		String headers[] =
			{	UIPlugin.getResourceString("HEADER_ATTRIBUTE"),
				UIPlugin.getResourceString("HEADER_OPERATOR"),
				UIPlugin.getResourceString("HEADER_VALUE")};
		ColumnLayoutData layouts[] =
			{	new ColumnPixelData(120, true),
				new ColumnPixelData(70, true),
				new ColumnPixelData(130, true)};
	
		final TableColumn columns[] = new TableColumn[headers.length];
		
		for (int i = 0; i < headers.length; i++) {
			layout.addColumnData(layouts[i]);
			TableColumn tc = new TableColumn(_table, SWT.NONE, i);
			tc.setResizable(layouts[i].resizable);
			tc.setText(headers[i]);
			columns[i] = tc;
		}
	}

	public boolean storeValues(IPreferenceStore store,String preferenceProperty) {
	//	return FilterTableElement.saveFilters(_filterList.getFilters(),preferenceProperty,store);
		return true;
	}
	
	public boolean storeValues(IPreferenceStore store) {
		//return FilterTableElement.saveFilters(_filterList.getFilters(),LogUIConstants.PD_ADV_FILTER_OPTIONS,store);
		return true;
	}
	
	public Composite getControl() {
		return result;
	}
	
	protected void enableButtons() {
		int selection = _table.getSelectionIndex();
		int selectionCount = _table.getSelectionCount();
	
		_removeBtn.setEnabled(getTableLength() > 0 && selection != -1);
		_editBtn.setEnabled(getTableLength() > 0 && selection != -1 && selectionCount == 1);
	
/*		_upBtn.setEnabled(selection > 0 && selectionCount == 1);
		_downBtn.setEnabled(selection >= 0
				&& selection < _table.getItemCount() - 1
				&& selectionCount == 1);
*/
	}
	
	protected void selectTableItem(Table table, int selection) {
		table.setFocus();
		table.setSelection(selection);
		table.showSelection();
	}
	
	private void showEditDialog(String title, FilterElement fe) {
	
		EditDialog dialog;
		
		if (fe != null)
			dialog = new EditDialog(result.getShell(), title, fe.attribute(), fe.operator(), fe.value());
		else
			dialog = new EditDialog(result.getShell(), title, null, null, null);
			
		dialog.open();
	
		if (dialog.getReturnCode() == Window.OK) {
			
			if (fe != null)
			{
				fe.setAttribute(dialog.attribute());
				fe.setOperator(dialog.operator());
				fe.setValue(dialog.value());
				_tableViewer.refresh();				
			}
			else
			{
				_filterElementSet.addFilterElement(new FilterElement(dialog.attribute(), dialog.operator(), dialog.value()));
				_tableViewer.refresh();		
				selectTableItem(_table, getTableLength() - 1);
			}
		}
		
		validateValues();
	}
	
	private void validateValues()
	{
		for (int i = 0; i < _filterElementSet.size(); i++)
		{
			FilterElement fe = _filterElementSet.filterElement(i);
			String errorMsg = fe.attribute().validate(fe.operator(), fe.value());
			if (errorMsg != null)
			{
				setError(errorMsg);
				return;
			}
		}
		
		noError();
	}
	
	private void addButtonPressed()
	{
		showEditDialog(
				UIPlugin.getResourceString("STR_ADD_FILTER_DLG"),
				null);
			enableButtons();
	}
	
	private void editButtonPressed()
	{
		int idx = _table.getSelectionIndex();
		if (idx != -1) {
			
			FilterElement fe = getFilterElement(idx);
			
			showEditDialog(
				UIPlugin.getResourceString("STR_EDIT_FILTER_DLG"),
				fe);
		}
	}	

	
	private void removeButtonPressed()
	{
		 int selection = _table.getSelectionIndex();
		
		 int indeces [] = _table.getSelectionIndices();

		 for (int i = 0; i < indeces.length; i++)
		 	_filterElementSet.removeFilterElement(_filterElementSet.filterElement(indeces[i]));
		
		_tableViewer.refresh();
		
		int size = getTableLength();
		if (size > 0) {
			if (selection > 0 && selection < size) {
				selectTableItem(_table, selection - 1);
			} else {
				selectTableItem(_table, 0);
			}
		}
		enableButtons();
		
		validateValues();
	}		
	
/*	private void upButtonPressed()
	{
		_tableViewer.refresh();
		
				int selection = _table.getSelectionIndex();
				if (selection > 0) {
					FilterTableElement sel =
						(FilterTableElement) _filterList.getElementAt(selection);
					FilterTableElement previous =
						(FilterTableElement) _filterList.getElementAt(
							selection - 1);
		
					String attribute = sel.getAttribute();
					String operator = sel.getOperator();
					String value = sel.getValue();
		
					sel.setAttribute(previous.getAttribute());
					sel.setOperator(previous.getOperator());
					sel.setValue(previous.getValue());
					
					previous.setAttribute(attribute);
					previous.setOperator(operator);
					previous.setValue(value);
			
					selectTableItem(_table, selection - 1);
				}
			_tableViewer.refresh();
			enableButtons();
					

	}*/		
	
/*	private void downButtonPressed()
	{
		_tableViewer.refresh();
		
				int selection = _table.getSelectionIndex();
				if (selection < _table.getItemCount() - 1) {
					FilterTableElement sel =
						(FilterTableElement) _filterList.getElementAt(selection);
					FilterTableElement next =
						(FilterTableElement) _filterList.getElementAt(
							selection + 1);
		
					String attribute = sel.getAttribute();
					String operator = sel.getOperator();
					String value = sel.getValue();
		
					sel.setAttribute(next.getAttribute());
					sel.setOperator(next.getOperator());
					sel.setValue(next.getValue());
		
					next.setAttribute(attribute);
					next.setOperator(operator);
					next.setValue(value);
		
					selectTableItem(_table, selection + 1);
				}
		
				_tableViewer.refresh();
				enableButtons();
	}*/		

	private void tableSelect()
	{
		enableButtons();
	}
	
	public String getTabName()
	{
		return UIPlugin.getResourceString("FILTERS_DIALOG_ADVANCED_TAB");
	}
	
	public Image getTabImage()
	{
		return PDPluginImages.getImage(PDPluginImages.IMG_VIEW_FILTER_OBJ);	
	}
	
	private FilterElement getFilterElement(int idx)
	{
		return (FilterElement)_tableViewer.getElementAt(idx);// ((IStructuredContentProvider)_tableViewer.getContentProvider()).getElements(getFilterSet())[idx];		
	}
	
	private int getTableLength()
	{
		return _filterElementSet.size();
	}
	
	private IFilterAttribute getAttributeFromString(String attributeStr)
	{
		for (int i = 0; i < _attributes.length; i++)
		{
			if (_attributes[i].displayText().equals(attributeStr))
				return _attributes[i];
		}
		return null;
	}
	
	private IFilterAttribute getAttributeFromID(String id)
	{
		for (int i = 0; i < _attributes.length; i++)
		{
			if (_attributes[i].id().equals(id))
				return _attributes[i];
		}
		return null;
	}	

	public void initializeFrom(SimpleSearchQuery filter) {
		FilterElementSet filterElementSet = new FilterElementSet();
		
		if (filter.getWhereExpression() != null 
				&& (filter.getWhereExpression() instanceof LogicalExpression))
		{
			 LogicalExpression logicalExpression = (LogicalExpression)filter.getWhereExpression();
		
			 EList filterElements = logicalExpression.getArguments();
			 for (int i = 0; i < filterElements.size(); i++)
			 {
			 	WhereExpression whereExpression = (WhereExpression)filterElements.get(i);
			 	String whereExpressionName = whereExpression.getName();
			 	int idx = whereExpressionName.indexOf(":");
			 	if (idx >= 0)
			 	{
				 	IFilterAttribute filterAttribute = getAttributeFromID(whereExpressionName.substring(idx+1));
				 	
				 	if (filterAttribute != null)
				 	{
				 		String feOperator = filterAttribute.getOperator(whereExpression);
				 		String feValue = filterAttribute.getValue(whereExpression);
				 		
				 		if (feOperator != null && feValue != null)
					 		filterElementSet.addFilterElement(new FilterElement(filterAttribute, feOperator, feValue));
				 	}
			 	}
			 }
		}
		
		_filterElementSet = filterElementSet;
		
		_tableViewer.refresh();		
	}
	
	public SimpleSearchQuery performApply() {
		SimpleSearchQuery filter = ExtensionsFactory.eINSTANCE.createSimpleSearchQuery();
		LogicalExpression logicalExpression = ExtensionsFactory.eINSTANCE.createLogicalExpression();
		logicalExpression.setOperator(LogicalOperators.AND_LITERAL);
		EList arguments = logicalExpression.getArguments();
		
		int subLogicalExpressionIdx = 0;
		BinaryExpression pbe = null;
		for (int i = 0; i < _filterElementSet.size(); i++)
		{
			FilterElement fe = _filterElementSet.filterElement(i);

			WhereExpression whereExpression = fe.attribute().getWhereExpression(fe.operator(), fe.value());
			
			if (whereExpression != null)
			{
				whereExpression.setName(getWhereExpressionName(logicalExpression, fe.attribute()));
				arguments.add(whereExpression);
			}
		}
		
		filter.setWhereExpression(logicalExpression);		
		return filter;
	}
	
	protected void selectItem(int item)
	{
		if (item >= 0 && item < _table.getItemCount())
			selectTableItem(_table, item);		
	}
	
	public static String getWhereExpressionName(LogicalExpression advancedLogicalExpression, IFilterAttribute filterAttribute)
	{
		return "AD" + advancedLogicalExpression.getArguments().size() + ":" + filterAttribute.id();
	}
}
