/**********************************************************************
 * Copyright (c) 2005 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.ui.filters.internal.dialogs;


import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.filters.FiltersStandardTabUI;
import org.eclipse.hyades.trace.ui.filters.internal.util.FilterInformationManager;
import org.eclipse.hyades.trace.ui.filters.internal.util.FilterQueries;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class FiltersDialog extends TitleAreaDialog {
	private FiltersStandardTabUI _standardTabUI;
	private FiltersAdvancedUI _advancedTabUI;	
	private Text _filterNameText;
	private FilterQueries _fq;
	private FilterInformationManager _fi;	
	private TabFolder _folder;
	private int _openTabIndex;
	private int _advancedTabSelectionIndex;	
	
	private String _errorMessage;
	
	private String _originalFilterName; 
	
	/**
	 * @param parentShell
	 */
	protected FiltersDialog(FilterQueries fq, FilterInformationManager fi, int openTabIndex, int advancedTabSelectionIndex) {
		super(Display.getDefault().getActiveShell());
		
		_openTabIndex = openTabIndex;
		_advancedTabSelectionIndex = advancedTabSelectionIndex;		
		_fq = fq;
		_fi = fi;
		
		_errorMessage = null;
	}
	
	protected void setTabUIs(FiltersStandardTabUI standardTabUI, FiltersAdvancedUI advancedTabUI)
	{
		_standardTabUI = standardTabUI;
		_advancedTabUI = advancedTabUI;
	}
	
	protected Control createDialogArea(Composite parent)
	{
		getShell().setText(UIPlugin.getResourceString("FILTERS_DIALOG_TITLE"));
		setTitleImage(PDPluginImages.getImage(PDPluginImages.IMG_UI_WZ_FILTER));
		
		Composite content = new Composite(parent, SWT.NULL);
		
		GridLayout layout;
		layout = new GridLayout();
		content.setLayout(layout);
		GridData data = GridUtil.createFill(); //new GridData(GridData.GRAB_HORIZONTAL | GridData.FILL);
//		data.heightHint = 375;
//		data.widthHint = 575;		
		content.setLayoutData(data);

		createBlankContent(content, 10);		
		createFilterNameControl(content);
		createBlankContent(content, 10);
		
		_folder = createTabsControl(content);

		Label separatorLine = new Label(content, SWT.SEPARATOR | SWT.HORIZONTAL);
		separatorLine.setLayoutData(GridUtil.createHorizontalFill());

		setTitle(UIPlugin.getResourceString("STR_FILTER_DIALOG_TITLE"));
		setMessage(UIPlugin.getResourceString("STR_FILTER_DIALOG_MESSAGE"));
		
		initialize();
		
		return content;
	}
	
	private TabFolder createTabsControl(Composite parent)
	{
		TabFolder folder = new TabFolder(parent, SWT.TOP);

		TabItem item;
		
		if (_standardTabUI != null)
		{
			item = new TabItem(folder, SWT.TOP);
			item.setText(_standardTabUI.getTabName());
			item.setImage(_standardTabUI.getTabImage());
			item.setControl(_standardTabUI.createControl(folder));
		}
		
		if (_advancedTabUI != null)
		{
			item = new TabItem(folder, SWT.TOP);
			item.setText(_advancedTabUI.getTabName());
			item.setImage(_advancedTabUI.getTabImage());
			item.setControl(_advancedTabUI.createControl(folder));
		}

		if (_openTabIndex >= 0 && _openTabIndex < folder.getItemCount())
			folder.setSelection(_openTabIndex);
		
		return folder;
	}
	
	private Control createFilterNameControl(Composite parent)
	{
		Composite content = new Composite(parent, SWT.NULL);
		GridLayout layout = new GridLayout();
		layout.numColumns = 2;
		content.setLayout(layout);
		content.setLayoutData(GridUtil.createFill());				
		
		Label labelName = new Label(content, SWT.NULL);
		labelName.setText(UIPlugin.getResourceString("FILTER_NAME_LABEL_NAME"));
		
		_filterNameText = new Text(content, SWT.BORDER);
		GridData data = new GridData();
		data.widthHint = 250;
		//_filterNameText.setLayoutData(GridUtil.createHorizontalFill());
		_filterNameText.setLayoutData(data);
		_filterNameText.setTextLimit(41);
		_filterNameText.addKeyListener(new KeyAdapter() {
			public void keyReleased(KeyEvent key) {
				if ("".equals(_filterNameText.getText().trim()))
					setError(UIPlugin.getResourceString("STR_FILTER_DIALOG_ERROR_NAME_BLANK"));				
				else if (UIPlugin.getResourceString("STR_DROPDOWN_NO_FILTER").equalsIgnoreCase(_filterNameText.getText().trim()))
					setError(UIPlugin.getResourceString("STR_FILTER_DIALOG_ERROR_NAME_RESERVED"));					
				else if (_fi.filterNameExists(_filterNameText.getText().trim()) && !_originalFilterName.equals(_filterNameText.getText().trim()))
					setError(UIPlugin.getResourceString("STR_FILTER_DIALOG_ERROR_NAME_EXISTS"));
				else
					noError();

			}
		});
		
		
		return content;
	}
	
	private Control createBlankContent(Composite parent, int heightHint)
	{
		Composite blankContent = new Composite(parent, SWT.NULL);
		GridData data = new GridData();
		data.heightHint = heightHint;
		blankContent.setLayoutData(data);	
		
		return blankContent;
	}
	
	public void updateErrorCompleteState()
	{
		if (_errorMessage != null)
		{	
			setErrorMessage(_errorMessage);
			setComplete(false);
			return;
		}		
		
		if (_standardTabUI != null && _standardTabUI.getError() != null)
		{	
			setErrorMessage(_standardTabUI.getError());
			setComplete(false);
			return;
		}

		if (_advancedTabUI != null && _advancedTabUI.getError() != null)
		{	
			setErrorMessage(_advancedTabUI.getError());
			setComplete(false);
			return;
		}
		
		setErrorMessage(null);

		if (_standardTabUI != null && !_standardTabUI.getComplete())
			setComplete(false);

		if (_advancedTabUI != null && !_advancedTabUI.getComplete())
			setComplete(false);		
		
		setComplete(true);
	}
	
	private void setError(String error)
	{
		_errorMessage = error;
		updateErrorCompleteState();		
	}	
	
	private void noError()
	{
		_errorMessage = null;
		updateErrorCompleteState();		
	}	
	
	private void setComplete(boolean complete)
	{
		if (getButton(IDialogConstants.OK_ID) != null)
			getButton(IDialogConstants.OK_ID).setEnabled(complete);
	}
	
	protected void okPressed()
	{
		_fq.name(_filterNameText.getText().trim());
		
		SimpleSearchQuery query = null;
		
		if (_standardTabUI != null)
		{
			query = _standardTabUI.performApply();
			if (query != null)
				_fq.standard(query);
		}
		
		if (_advancedTabUI != null)
		{
			query = _advancedTabUI.performApply();
			if (query != null)
				_fq.advanced(query);
		}
	
		super.okPressed();
	}
	
	private void initialize()
	{
		_filterNameText.setText(_fq.name());
		_originalFilterName = _fq.name();
		
		if (_standardTabUI != null)
			_standardTabUI.initializeFrom(_fq.standard());
		
		if (_advancedTabUI != null)
		{
			_advancedTabUI.initializeFrom(_fq.advanced());		
			_advancedTabUI.selectItem(_advancedTabSelectionIndex);
		}
	}
}
