/**********************************************************************
 * Copyright (c) 2005 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.ui.filters.internal.dialogs;


import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.filters.internal.util.FilterInformationManager;
import org.eclipse.hyades.trace.ui.filters.internal.util.FilterQueries;
import org.eclipse.hyades.trace.ui.internal.filters.FilterTypesManager;
import org.eclipse.hyades.trace.ui.internal.filters.IFilterType;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.model.WorkbenchViewerSorter;

public class FiltersEditDialog extends Dialog {

	private TableViewer _filtersListViewer;
	private FilterInformationManager _fi;
	
	private Button _newButton;
	private Button _removeButton;
	private Button _editButton;
	
//	private Button _moveUpButton;
//	private Button _moveDownButton;
	
	private String _selectedFilterName = null;
	
	public class FilterSetLabelProvider extends LabelProvider
	{

		public String getText(Object element) {
			return ((FilterQueries)element).name();
		}
		
		public Image getImage(Object element) {
			ImageDescriptor icon = FilterTypesManager.instance().getFilterType(((FilterQueries)element).type()).icon();
			if (icon != null)
				return icon.createImage();
			else
				return null;
		}		
		
		
		public void dispose() {
		}
		
	}
	
	public class FilterSetContentProvider implements IStructuredContentProvider
	{
		/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.IStructuredContentProvider#getElements(java.lang.Object)
		 */
		public Object[] getElements(Object inputElement) {
			if (_fi != null && _fi == inputElement) {
				return _fi.getFiltersArray();
			}
			return new Object[0];			
		}

		/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.IContentProvider#dispose()
		 */
		public void dispose() {
		}

		/* (non-Javadoc)
		 * @see org.eclipse.jface.viewers.IContentProvider#inputChanged(org.eclipse.jface.viewers.Viewer, java.lang.Object, java.lang.Object)
		 */
		public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		}
		
	}	

	protected FiltersEditDialog(FilterInformationManager fi) {
		super(Display.getDefault().getActiveShell());
		
		_fi = fi;
	}
	
	protected Control createDialogArea(Composite parent)
	{
		getShell().setText(UIPlugin.getResourceString("EDIT_FILTERS_DIALOG_TITLE"));
		
		Composite composite = (Composite) super.createDialogArea(parent);

		createMessageLabel(composite);
		
		Composite listComposite = new Composite(composite, SWT.NULL);
		GridLayout layout;
		layout = new GridLayout();
		layout.numColumns = 1;
		listComposite.setLayout(layout);		
		
		_filtersListViewer = new TableViewer(listComposite, SWT.BORDER | SWT.MULTI);
		GridData data = new GridData(GridData.HORIZONTAL_ALIGN_FILL);
		data.grabExcessHorizontalSpace = true;
		data.heightHint = 200;
		data.widthHint = 200;
		_filtersListViewer.getTable().setLayoutData(data);		
		_filtersListViewer.getTable().addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				tableSelect();
			}
		});		
		
		_filtersListViewer.setLabelProvider(new FilterSetLabelProvider());
		_filtersListViewer.setContentProvider(new FilterSetContentProvider());
		_filtersListViewer.setSorter(new WorkbenchViewerSorter());
		_filtersListViewer.addSelectionChangedListener(new ISelectionChangedListener() {
			public void selectionChanged(SelectionChangedEvent event) {
				//handleSelectionChanged();
			}
		});
		_filtersListViewer.addDoubleClickListener(new IDoubleClickListener() {
			public void doubleClick(DoubleClickEvent event) {
				//edit action?
			}
		});
		
//		createMoveButtonsControl(listComposite);
		
		createButtonsControl(composite);
		_filtersListViewer.setInput(_fi);
		_filtersListViewer.setSorter(null);
		_filtersListViewer.refresh();
		setInitialSelection();
		enableButtons();		
		
		return composite;
	}
	
	private Label createMessageLabel(Composite composite) {
		Label label = new Label(composite, SWT.NONE);
		label.setText(UIPlugin.getResourceString("EDIT_FILTERS_MESSAGE"));
		return label;
	}	
	
//	private Control createMoveButtonsControl(Composite composite) {
//		Composite buttonComposite = new Composite(composite, SWT.NULL);
//		GridLayout layout = new GridLayout();
//		layout.numColumns = 1;
//		buttonComposite.setLayout(layout);
//		GridData data = new GridData(GridData.HORIZONTAL_ALIGN_FILL | GridData.CENTER);
//		data.grabExcessHorizontalSpace = true;		
//		buttonComposite.setLayoutData(data);
//
//		_moveUpButton = createModifyButton(buttonComposite, UIPlugin.getResourceString("EDIT_FILTERS_MOVE_UP_BUTTON")); //$NON-NLS-1$
//		_moveUpButton.addSelectionListener(new SelectionAdapter() {
//			public void widgetSelected(SelectionEvent e) {
//				moveUpFilterSet();
//			}
//		});
//
//		_moveDownButton = createModifyButton(buttonComposite, UIPlugin.getResourceString("EDIT_FILTERS_MOVE_DOWN_BUTTON")); //$NON-NLS-1$
//		_moveDownButton.addSelectionListener(new SelectionAdapter() {
//			public void widgetSelected(SelectionEvent e) {
//				moveDownFilterSet();
//			}
//		});
//		
//		_moveUpButton.setEnabled(true);
//		_moveDownButton.setEnabled(true);		
//
//		return buttonComposite;
//		
//	}

	private Control createButtonsControl(Composite composite) {
		Composite buttonComposite = new Composite(composite, SWT.NULL);
		GridLayout layout = new GridLayout();
		layout.numColumns = 3;
		layout.makeColumnsEqualWidth = true;
		buttonComposite.setLayout(layout);
		GridData data = new GridData(GridData.HORIZONTAL_ALIGN_FILL | GridData.CENTER);
		data.grabExcessHorizontalSpace = true;		
		buttonComposite.setLayoutData(data);

		_newButton = createModifyButton(buttonComposite, UIPlugin.getResourceString("EDIT_FILTERS_NEW_BUTTON")); //$NON-NLS-1$
		_newButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				createFilterSet();
			}
		});

		_editButton = createModifyButton(buttonComposite, UIPlugin.getResourceString("EDIT_FILTERS_EDIT_BUTTON")); //$NON-NLS-1$
		_editButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				editFilterSet();
			}
		});

		_removeButton = createModifyButton(buttonComposite, UIPlugin.getResourceString("EDIT_FILTERS_REMOVE_BUTTON")); //$NON-NLS-1$
		_removeButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				removeFilterSets();
			}
		});
		
		_newButton.setEnabled(true);

		return buttonComposite;
	}
	
	private Button createModifyButton(Composite parent, String text)
	{
		Button button = new Button(parent, SWT.PUSH);
		GridData data = new GridData(GridData.HORIZONTAL_ALIGN_FILL);
		button.setLayoutData(data);
		button.setText(text);
		return button;
	}
	
	private void createFilterSet()
	{
		FilterTypeDialog filterTypeDialog = FilterUIUtil.getFiltersTypeDialog(_fi);
		filterTypeDialog.open();
		
		IFilterType type = filterTypeDialog.selectedFilterType();

		if (type == null)
			return;
		
		FilterQueries fq = _fi.createFilterQueries(type.id());
		
		FiltersDialog filtersDialog = FilterUIUtil.getFiltersDialog(fq, _fi, 0);
		filtersDialog.open();
		
		if (filtersDialog.getReturnCode() == FiltersDialog.OK)
		{
			_fi.addFilter(fq);

			_filtersListViewer.refresh();
			setSelectedFilter(fq.name());		
			enableButtons();
		}
	}
	
	private void editFilterSet()
	{
		int idx = _filtersListViewer.getTable().getSelectionIndex();
		if (idx != -1) {
			FilterQueries sel =
				(FilterQueries) _fi.filter(idx);
		
			FilterQueries copy = sel.copy();
			FiltersDialog filtersDialog = FilterUIUtil.getFiltersDialog(copy, _fi, 0);
			filtersDialog.open();
			
			if (filtersDialog.getReturnCode() == FiltersDialog.OK)
			{
				_fi.removeFilter(sel);
				_fi.addFilter(copy);			
				_filtersListViewer.refresh();
				
				setSelectedFilter(copy.name());
			}
		}
	}	
	
	private void removeFilterSets()
	{
		int selection = _filtersListViewer.getTable().getSelectionIndex();
			
		 _fi.removeFilters(_filtersListViewer.getTable().getSelectionIndices());
			
		 _filtersListViewer.refresh();
			
		 int size = _fi.size();
		 if (size > 0) {
		 	if (selection > 0 && selection < size) {
		 		selectTableItem(_filtersListViewer.getTable(), selection - 1);
			} else {
				selectTableItem(_filtersListViewer.getTable(), 0);
			}
		 }
		
		 enableButtons();		
	}
	
//	private void moveUpFilterSet()
//	{
//		int idx = _filtersListViewer.getTable().getSelectionIndex();
//		if (idx > 0 && idx < _fi.size()) {
//			_fi.moveUp(idx);
//			
//			_filtersListViewer.refresh();
//			selectTableItem(_filtersListViewer.getTable(), idx-1);
//			enableButtons();
//		}
//		
//	}
	
//	private void moveDownFilterSet()
//	{
//		
//		int idx = _filtersListViewer.getTable().getSelectionIndex();
//		if (idx >= 0 && idx < (_fi.size() - 1)) {
//			_fi.moveDown(idx);
//			
//			_filtersListViewer.refresh();		
//			selectTableItem(_filtersListViewer.getTable(), idx+1);
//			enableButtons();			
//		}
//	}
	

	protected void selectTableItem(Table table, int selection) {
		table.setFocus();
		table.setSelection(selection);
		table.showSelection();
	}	
	
	protected void enableButtons() {
		int selection = _filtersListViewer.getTable().getSelectionIndex();
		int selectionCount = _filtersListViewer.getTable().getSelectionCount();
	
		_removeButton.setEnabled(_fi.size() > 0 && selection != -1);
		_editButton.setEnabled(_fi.size() > 0 && selection != -1 && selectionCount == 1);
		
//		_moveUpButton.setEnabled(selection > 0 && selection < _fi.size() && selectionCount == 1);
//		_moveDownButton.setEnabled(selection >= 0 && selection < (_fi.size() - 1) && selectionCount == 1);		
	}	
	
	private void tableSelect()
	{
		enableButtons();
	}	
	
	protected void okPressed() {
		int selection = _filtersListViewer.getTable().getSelectionIndex();
		
		super.okPressed();
		_fi.save();

		if (selection >= 0)
			_selectedFilterName = _fi.filter(selection).name();
		else
			_selectedFilterName = null;
	}
	
	protected void cancelPressed() {
		super.cancelPressed();

		_fi.restore();		
	}
	
	public String selectedFilterName()
	{
		return _selectedFilterName;
	}
	
	public void selectedFilterName(String selectedFilterName)
	{
		_selectedFilterName = selectedFilterName;
	}	
	
	private void setInitialSelection()
	{
		setSelectedFilter(_selectedFilterName);
	}
	
	private void setSelectedFilter(String name)
	{
		if (name != null)
		{
			for (int i = 0; i < _fi.size(); i++)
			{
				if (name.equals(_fi.filter(i).name()))
				{
					selectTableItem(_filtersListViewer.getTable(), i);
					return;
				}
			}
		}		
	}
}
