/**********************************************************************
 * Copyright (c) 2005 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.ui.filters.internal.dialogs;

import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class FiltersTabUI {

	private FiltersDialog _dialog;
	private String _errorMessage;
	private boolean _complete;	
	
	protected abstract String getTabName();
	protected abstract Image getTabImage();

	public abstract Control createControl(Composite parent);
	public abstract void initializeFrom(SimpleSearchQuery filter);
	public abstract SimpleSearchQuery performApply();
	
	protected final void initializeDialog(FiltersDialog dialog)
	{
		_dialog = dialog;
		_errorMessage = null;
		_complete = true;
	}

	public final void setComplete(boolean complete)
	{
		_complete = true;
		_dialog.updateErrorCompleteState();
	}
	
	public final boolean getComplete()
	{
		return _complete;
	}
	
	public final void setError(String error)
	{
		_errorMessage = error;
		_dialog.updateErrorCompleteState();
	}
	
	public final String getError()
	{
		return _errorMessage;
	}
	
	public final void noError()
	{
		_errorMessage = null;
		_dialog.updateErrorCompleteState();
	}	
}
