/**********************************************************************
 * Copyright (c) 2005 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.ui.filters.internal.util;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.hyades.models.hierarchy.extensions.RelationalOperators;

public class FilterElement {
	private EAttribute _attribute;
	private RelationalOperators _operator;
	private String _value;
	
	public FilterElement(EAttribute attribute, RelationalOperators operator, String value)
	{
		_attribute = attribute;
		_operator = operator;
		_value = value;
	}
	
	public EAttribute attribute()
	{
		return _attribute;
	}
	
	public RelationalOperators operator()
	{
		return _operator;
	}
	
	public String value()
	{
		return _value;
	}
	
	public void setAttribute(EAttribute attribute)
	{
		_attribute = attribute;
	}
	
	public void setOperator(RelationalOperators operator)
	{
		_operator = operator;
	}
	
	public void setValue(String value)
	{
		_value = value;
	}	
}
