/**********************************************************************
 * Copyright (c) 2005 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.ui.filters.internal.util;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.emf.common.util.URI;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsFactory;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;
import org.eclipse.hyades.trace.ui.UIPlugin;


public class FilterResourceHandler extends FilterResourceFileHandler {
	private static String TYPE_DIR = "/filterresources/";
	private static String TYPE_FILE = ".filtxmi";	
	private static String FILTERS_FILE_NAME = "filters";
	private static String DEFAULT_FILTER_KEY_PREFIX = "org.eclipse.hyades.trace.ui.filters.internal.defaultFilters.";	
	
	private static FilterResourceHandler _instance = null;
	private static List _filtersToAddOnInstanceLoad = null;
	
	protected FilterResourceHandler(URI uri)
	{
		super(uri);
	}
	
	public static FilterResourceHandler instance()
	{
		if (_instance == null)
		{
			_instance = new FilterResourceHandler(createMasterListFileURI());
			addFiltersOnInstanceLoad(null);
		}
		
		return _instance;
	}
	
	public static URI createMasterListFileURI()
	{
		String fileName = UIPlugin.getDefault().getStateLocation().toString() + TYPE_DIR + FILTERS_FILE_NAME + TYPE_FILE; 
		return URI.createFileURI(fileName);
	}	
	
	
	public FilterQueries createFilterQueries(String type)
	{
		return createFilterQueries(type, null, null);
	}
	
	public FilterQueries createFilterQueries(String type, SimpleSearchQuery standardQuery, SimpleSearchQuery advancedQuery)
	{
		return createFilterQueries(type, getNewFilterSetName(), standardQuery, advancedQuery);
	}

	public static FilterQueries createFilterQueries(String type, String name, SimpleSearchQuery standardQuery, SimpleSearchQuery advancedQuery)
	{
		FilterQueries fq = new FilterQueries();

		fq.type(type);		
		fq.name(name);	
		
		if (standardQuery != null)
			fq.standard(standardQuery);
		else
			fq.standard(ExtensionsFactory.eINSTANCE.createSimpleSearchQuery());			

		if (advancedQuery != null)
			fq.advanced(advancedQuery);
		else
			fq.advanced(ExtensionsFactory.eINSTANCE.createSimpleSearchQuery());

		return fq;
	}
	

	private String getNewFilterSetName()
	{
		String defaultName = UIPlugin.getResourceString("FILTERS_NEW_BASE_NAME");
		
		int i = 1;
		String name = defaultName;
		while (filter(name) != null)
		{
			name = defaultName + " (" + i + ")";
			i++;
		}
		
		return name;
	}
	
	public static synchronized void addFiltersOnInstanceLoad(List filters)
	{
		if (_filtersToAddOnInstanceLoad == null)
			_filtersToAddOnInstanceLoad = new ArrayList();
		
		if (filters != null)
			_filtersToAddOnInstanceLoad.addAll(filters);
		
		if (_instance == null || _filtersToAddOnInstanceLoad == null)
			return;
		
		for (int i = 0; i < _filtersToAddOnInstanceLoad.size(); i++)
			_instance.addFilter((FilterQueries)_filtersToAddOnInstanceLoad.get(i));

		_instance.save();
		
		_filtersToAddOnInstanceLoad.clear();		
	}
	
	public static boolean isDefaultFiltersAddedForKey(String key)
	{
		return UIPlugin.getDefault().getPluginPreferences().getBoolean(DEFAULT_FILTER_KEY_PREFIX + key);
	}
	
	public static void defaultFiltersAddedForKey(String key, boolean added)
	{
		UIPlugin.getDefault().getPluginPreferences().setValue(DEFAULT_FILTER_KEY_PREFIX + key, added);
	}	
}
