/**********************************************************************
 * Copyright (c) 2005 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.ui.filters.internal.util;

import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;

import org.eclipse.hyades.trace.ui.filters.FiltersStandardTabUI;
import org.eclipse.hyades.trace.ui.filters.IAdvancedTabAttributeSet;
import org.eclipse.hyades.trace.ui.internal.filters.IFilterType;
import org.eclipse.jface.resource.ImageDescriptor;

public class FilterType implements IFilterType {
	private String _id;
	private String _name;
	private ImageDescriptor _icon;
	private String _description;
	private FiltersStandardTabUI _standardTabUI;
	private IAdvancedTabAttributeSet _advancedTabAttributeSet;
	private String[] _scope;

	
	public FilterType(
			String id,
			String name,
			ImageDescriptor icon,
			String description,
			FiltersStandardTabUI standardTabUI,
			IAdvancedTabAttributeSet advancedTabAttributeSet,
			String[] scope
			)
	{
		_id = id;
		_name = name;
		_icon = icon;
		_description = description;
		_standardTabUI = standardTabUI;
		_advancedTabAttributeSet = advancedTabAttributeSet;
		_scope = scope;
		
		Arrays.sort(_scope, new Comparator() {
			public int compare(Object a, Object b) {
				String str1 = (String)a;
				String str2 = (String)b;
				
				if (str1 == null)
					str1 = "";//$NON-NLS-1$
				if (str2 == null)
					str2 = "";//$NON-NLS-1$
				
				return Collator.getInstance().compare(str1, str2);				
			}
		});		
	}
	
	public String id()
	{
		return _id;
	}
	
	public String name()
	{
		return _name;
	}	
	
	public ImageDescriptor icon()
	{
		return _icon;
	}

	public String description()
	{
		return _description;
	}	
	
	public FiltersStandardTabUI standardTabUI()
	{
		return _standardTabUI; 
	}
	
	public IAdvancedTabAttributeSet advancedTabAttributeSet()
	{
		return _advancedTabAttributeSet;
	}

	public String[] scope() {
		return _scope;
	}
	
    public boolean equals(Object obj)
	{
		if (this == obj)
			return true;
		
		if (obj == null)
			return false;
		
		if (obj instanceof IFilterType)
		{
			return id().equals(((IFilterType)obj).id());
		}
		
		return false;
	}
}
