/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: StartTraceActionDelegate.java,v 1.8 2005/02/16 22:23:47 qiyanli Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.ui.internal.actions;

import java.io.File;

import org.eclipse.hyades.internal.execution.local.common.CustomCommand;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.piclient.XMLTraceDataProcessor;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.jface.dialogs.MessageDialog;


/*
 * CONTEXT_ID srtr0000 for start monitor(trace) action
 */
public class StartTraceActionDelegate extends AbstractListenerActionDelegate {

    /**
     * @see AbstractProfileActionDelegate#doAction(Object)
     */
    public void doAction(Object object) throws Exception {
        if ((object == null) || !(object instanceof TRCAgentProxy)) {
            return;
        }

        //PDProjectExplorer fViewer = UIPlugin.getDefault().getViewer();
		INavigator fViewer = (INavigator)getView();

        if (fViewer == null) {
            MessageDialog.openInformation(UIPlugin.getActiveWorkbenchShell(), "title", "Action not available in current context");

            return;
        }

        run((TRCAgentProxy) object, fViewer);
    }

    public void run(TRCAgentProxy agent, INavigator fViewer) {
        TRCProcessProxy process = agent.getProcessProxy();
        String host = process.getNode().getName();

        try {
            Node node = PDCoreUtil.profileConnect(host, String.valueOf(process.getNode().getPort()));

            if (node == null) {
                return;
            }

			Object instance = LoadersUtils.locateAgentInstance(agent);
			if(instance != null && instance instanceof Agent)
			{
				Agent a = (Agent)instance;

                if (a.isActive()) {
                    if (agent.isToProfileFile()) {
                        a.setProfileFile(agent.getProfileFile());
                    } else {
                        a.setProfileFile(null);
                    }

                    PDCoreUtil.setAgentConfiguration(agent, a);
                    a.publishConfiguration();

                    CustomCommand command = new CustomCommand();

                    command.setData("APPLYFILTERS");
                    a.invokeCustomCommand(command);

                    XMLTraceDataProcessor processor = (XMLTraceDataProcessor) LoadersUtils.locateDataProcessor(agent);

                    if (processor == null) {
                        processor = new XMLTraceDataProcessor(agent);
                        LoadersUtils.registerDataProcessor(agent, processor);
//						LoadersUtils.loadRootEvent(processor);
                    }
                    
                    if (processor != null) {
                        String processorProfileFileName = processor.getProfileFileName();
						File processorProfilingFile = processorProfileFileName == null ? null : new File(processorProfileFileName);
                        boolean newFile = true;

                        if (agent.isToProfileFile()) {
                            File testFile = new File(agent.getProfileFile());

                            if (testFile.exists()) {
                                newFile = false;
                            }
                        }

                        //just attach to agent, or profile to model before
                        if ((processorProfilingFile == null) && (agent.isToProfileFile())) {
                            processor.setProfileFileName(agent.getProfileFile());
                            processor.createWriter();
							newFile = processor.isNewProfileFile();

                            if (newFile) {
                                processor.writeXMLVersion(processor.getWriter());
								processor.startTrace(processor.getWriter());
                            }
                        }
                        
                        //profile file name changed while stop monitor/detach, or file deleted
                        else if ((processorProfileFileName != null) && (!processorProfileFileName.equals(agent.getProfileFile()) || !processorProfilingFile.exists())) {
                            if (processorProfilingFile.exists()) {
                                processor.endTrace(processor.getWriter());
                            }

                            processor.setProfileFileName(agent.getProfileFile());
                            processor.createWriter();
							newFile = processor.isNewProfileFile();


                            if (newFile) {
                                processor.writeXMLVersion(processor.getWriter());
								processor.startTrace(processor.getWriter());
                            }
                        }
                    }

                    a.startMonitoring(processor);

                    agent.setCollectionData(true);

                    // RKD:  The profiling agent has a custom command to resume the VM.  I assume there should be
                    //         code here to ensure that this command is only sent to the profiler.
                    //					a.invokeCustomCommand(new ResumeProcessCommand());
                    command.setData("RESUME");
                    a.invokeCustomCommand(command);
                    agent.setMonitored(true);
                    agent.setActive(true);
                    agent.setAttached(true);

                    ProfileEvent event = UIPlugin.getDefault().getProfileEvent();

                    event.setSource(agent);
                    event.setType(ProfileEvent.START_MONITOR);

                    UIPlugin.getDefault().notifyProfileEventListener(event);
                }
            }

            //update ui
            fViewer.getViewer().refresh(agent);
        } catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    /**
     * @see AbstractProfileActionDelegate#isEnabledFor(Object)
     */
    protected boolean isEnabledFor(Object element) {
        if ((element != null) && (element instanceof TRCAgentProxy) && (((TRCAgentProxy) element).isAttached() && !((TRCAgentProxy) element).isMonitored())) {
            return true;
        }

        return false;
    }
	public void dispose()
	{
		super.dispose();
	}
}
