/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TraceAssociationManager.java,v 1.4 2005/02/16 22:23:47 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.trace.ui.internal.core;

import org.eclipse.hyades.trace.internal.ui.TraceConstants;
import org.eclipse.hyades.ui.HyadesUI;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.extension.*;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

/**
 * Contains utility methods to work with the Test UI extensions.
 * 
 * @author marcelop
 * @since 0.0.1
 */
public class TraceAssociationManager
{ 
	private static class TraceDescriptorFilter
	implements IAssociationDescriptorFilter
	{
		/**
		 * @see org.eclipse.hyades.ui.extension.IAssociationDescriptorFilter#isValid(org.eclipse.hyades.ui.extension.IAssociationMapping, org.eclipse.hyades.ui.extension.IAssociationDescriptor)
		 */
		public boolean isValid(IAssociationMapping associationMapping, IAssociationDescriptor associationDescriptor)
		{
			if(!TraceConstants.TRACE_EXTENSION.equals(associationDescriptor.getExtension()))
				return false;

			String extensionPoint = associationMapping.getExtensionPoint();
			if(HyadesUIPlugin.EP_TYPE_DESCRIPTIONS.equals(extensionPoint))
			{
				if(associationDescriptor.applyToAllTypes())
					return false;
						
				if(associationDescriptor.types().length != 1)
					return false;
						
				if(associationDescriptor.getImageDescriptor() == null)
					associationDescriptor.setImageDescriptor(TraceUIImages.INSTANCE.getImageDescriptor(TraceUIImages.IMG_UNCHECKED));
			}
			else if(HyadesUIPlugin.EP_ANALYZER_EXTENSIONS.equals(extensionPoint))
			{
				if(associationDescriptor.getImageDescriptor() == null)
					associationDescriptor.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(ISharedImages.IMG_OBJ_FILE));
			}
			
			return true;
		}
	}
	
	/**
	 * The Hyades generic test suite type
	 */
	public final static String GENERIC_TEST_SUITE_TYPE = "org.eclipse.hyades.GenericTestSuite";

	/**
	 * The Hyades generic test suite editor that is registered to the Eclipse
	 * framework. 
	 */
	public final static String GENERIC_TEST_SUITE_EDITOR_PART_ID = "org.eclipse.hyades.test.ui.editor.TestSuiteEditorPart";

	/*
	 * Association mapping registries.
	 */
	private static IAssociationMappingRegistry traceViewMappingRegistry;
	
	/**
	 * Disposes the resources used by this class.
	 */
	public static void dispose()
	{
		if(traceViewMappingRegistry != null)
			traceViewMappingRegistry.dispose();
	}
	
	/**
	 * Returns the Test Suite's Association mapping registry.
	 * 
	 * <p>When this method is called for the first time it initializes
	 * the registry.
	 * 
	 * @return IAssociationMappingRegistry
	 */
	public static IAssociationMappingRegistry getTraceViewMappingRegistry()
	{
		if(traceViewMappingRegistry == null)
		{
			traceViewMappingRegistry = HyadesUI.createAssociationMappingRegistry();
			traceViewMappingRegistry.initialize(TraceConstants.TRACE_EXTENSION, new TraceDescriptorFilter(), HyadesUIPlugin.getInstance().getPreferenceStore());
			traceViewMappingRegistry.retrieveAssociationMapping(HyadesUIPlugin.EP_TYPE_DESCRIPTIONS, HyadesUIPlugin.getID());
			traceViewMappingRegistry.retrieveAssociationMapping(HyadesUIPlugin.EP_ANALYZER_EXTENSIONS, HyadesUIPlugin.getID());
		}
		
		return traceViewMappingRegistry;
	}
	
	
}
