/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TraceNodeUI.java,v 1.5 2005/04/06 22:30:18 apnan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.core;

import java.text.DateFormat;

import org.eclipse.hyades.internal.execution.local.common.*;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.*;

/*
* CONTEXT_ID nnwp0000 for host address entry field in node wizard page
*/
/*
* CONTEXT_ID nnwp0001 for host name entry field in node wizard page
*/
/*
* CONTEXT_ID nnwp0002 for port number entry field in node wizard page
*/
/*
* CONTEXT_ID nnwp0003 for delta time entry field in node wizard page
*/

public class TraceNodeUI
{
	protected Text      _nodeAddress;
	protected Text      _nodeName; 
	protected Text	 _portNumber;
	protected Text	 _hour;
	protected Text	 _min;
	protected Text	 _sec;
	protected Text	 _micsec;
	
	protected Group 	deltaTime;
	
	private boolean    _haveSeperator = true;
/**
 * TraceOptionsUI constructor comment.
 */
public TraceNodeUI(boolean haveSeperator)
{
	super();
	_haveSeperator = haveSeperator;
}

public TraceNodeUI() {
	super();
}

/**
 * Insert the method's description here.
 * Creation date: (4/26/2001 3:45:54 PM)
 * @param parent com.ibm.swt.widgets.Composite
 */
public Composite createControl(Composite parent)
{
	Label label;

	Composite content = new Composite(parent, SWT.NONE);
	GridLayout layout = new GridLayout();
	layout.numColumns = 1;
	layout.verticalSpacing=5;       
	content.setLayout(layout);
	GridData gd = new GridData();
	gd.verticalAlignment   = GridData.FILL;
	gd.horizontalAlignment = GridData.FILL;
	gd.grabExcessHorizontalSpace = true;
	gd.widthHint = 500; 
	content.setLayoutData(gd);

	if (_haveSeperator)
	{
		Label sep = new Label(content, SWT.SEPARATOR | SWT.HORIZONTAL);
		GridData sepGrid = new GridData(GridData.FILL_HORIZONTAL);
		sepGrid.horizontalSpan = 1;
		sep.setLayoutData(sepGrid);
	}
	
//  top level group
	Composite group = new Composite( content, SWT.NULL );   
	group.setLayoutData( GridUtil.createHorizontalFill() );
	layout = new GridLayout();
	layout.numColumns = 2;  
	layout.verticalSpacing=5;   
	group.setLayout( layout );
	
	Label label1 = new Label(group, SWT.NONE);
	label1.setText(UIPlugin.getResourceString("NODE_NAME"));
	_nodeName = new Text(group, SWT.SINGLE | SWT.BORDER);
	_nodeName.setLayoutData(GridUtil.createHorizontalFill());
	
	Label label2 = new Label(group, SWT.NONE);
	label2.setText(UIPlugin.getResourceString("NODE_ADDRESS")); 
	_nodeAddress = new Text(group, SWT.SINGLE | SWT.BORDER);
	_nodeAddress.setLayoutData(GridUtil.createHorizontalFill());

	Label label3 = new Label(group, SWT.NONE);
	label3.setText(UIPlugin.getResourceString("RAC_PORT_TEXT")); 
	_portNumber = new Text(group, SWT.SINGLE | SWT.BORDER);
	_portNumber.setLayoutData(GridUtil.createHorizontalFill());
	_portNumber.setText(String.valueOf(Constants.CTL_PORT_NUM_SERVER));

	deltaTime = new Group(content, SWT.NONE);
	layout = new GridLayout();
	layout.numColumns = 8;
	layout.verticalSpacing=5;       
	deltaTime.setLayout(layout);
	deltaTime.setLayoutData(GridUtil.createHorizontalFill());
	deltaTime.setText(UIPlugin.getResourceString("STR_SYNCH_NODE_TIME"));
	
	label = new Label(deltaTime, SWT.NONE);
	label.setText(UIPlugin.getResourceString("STR_DELTA_TIME"));
	
	_hour = new Text(deltaTime, SWT.BORDER);
	gd = new GridData();
	gd.widthHint = 40;
	_hour.setLayoutData(gd);
	_hour.setTextLimit(4);
	label = new Label(deltaTime, SWT.NONE);
	label.setText(":");	
	
	_min = new Text(deltaTime, SWT.BORDER);
	gd = new GridData();
	gd.widthHint = 30;
	_min.setLayoutData(gd);
	_min.setTextLimit(3);
	label = new Label(deltaTime, SWT.NONE);
	label.setText(":");	
	
	_sec = new Text(deltaTime, SWT.BORDER);
	gd = new GridData();
	gd.widthHint = 30;
	_sec.setLayoutData(gd);
	_sec.setTextLimit(3);
	label.setText(":");	
	
	_micsec = new Text(deltaTime, SWT.BORDER);
	gd = new GridData();
	gd.widthHint = 70;
	_micsec.setLayoutData(gd);
	_micsec.setTextLimit(7);

	label = new Label(deltaTime, SWT.NONE);
	label.setText(UIPlugin.getResourceString("STR_DELTA_HMS"));
	label = new Label(deltaTime, SWT.NONE);

	label.setText(UIPlugin.getResourceString("STR_DELTA_MICROSEC_EXAMPLE"));
	gd = new GridData();
	gd.horizontalSpan = 8;
	label.setLayoutData(gd);
	
	
	_nodeName.setFocus();
	
	org.eclipse.ui.help.WorkbenchHelp.setHelp(
		_nodeAddress,
		UIPlugin.getPluginId()+".nnwp0000");
	org.eclipse.ui.help.WorkbenchHelp.setHelp(
		_nodeName,
		UIPlugin.getPluginId()+".nnwp0001");
	org.eclipse.ui.help.WorkbenchHelp.setHelp(
		_portNumber,
		UIPlugin.getPluginId()+".nnwp0002");
	org.eclipse.ui.help.WorkbenchHelp.setHelp(
		_hour,
		UIPlugin.getPluginId()+".nnwp0003");
	
	return content;
}
/**
 * Insert the method's description here.
 * Creation date: (8/14/2001 1:14:45 PM)
 * @return org.eclipse.swt.widgets.Text
 */
public Text getAddressUI() {
	return _nodeAddress;
}
/**
 * Insert the method's description here.
 * Creation date: (8/14/2001 1:14:45 PM)
 * @return org.eclipse.swt.widgets.Text
 */
public Text getNodeNameUI() {
	return _nodeName;
}

public Text getPortNumberUI() {
	return _portNumber;
}

public Text getHourUI()
{
	return _hour;
}

public Text getMinUI()
{
	return _min;
}

public Text getSecUI()
{
	return _sec;
}

public Text getMicSecUI()
{
	return _micsec;
}

/**
 * Insert the method's description here.
 * Creation date: (8/14/2001 1:20:47 PM)
 * @param enable boolean
 */
public void setEnabled(boolean enable)
{
	_nodeName.setEnabled(enable);
	_nodeAddress.setEnabled(enable);
	//_portNumber.setEnabled(enable);
}

public double getDeltaTime()
{
	int hours = 0;
	try {
		hours = Integer.parseInt(_hour.getText());
	} catch (Exception exc) {
	}

	int min = 0;
	try {
		min = Integer.parseInt(_min.getText());
	} catch (Exception exc) {
	}
	int sec = 0;
	try {
		sec = Integer.parseInt(_sec.getText());
	} catch (Exception exc) {
	}
	int micsec = 0;
	try {
		micsec = Integer.parseInt(_micsec.getText());
	} catch (Exception exc) {
	}
	
	if(hours<0 || min<0 || sec<0 || micsec<0){
		return  -((double) (Math.abs(hours) * 3600 + Math.abs(min) * 60 + Math.abs(sec)) * 1000000 + Math.abs(micsec));
	}

	return ((double) hours * 3600 + min * 60 + sec) * 1000000 + micsec;
	
}

public void setDeltaTime(double delta)
{
	DateFormat df = DateFormat.getTimeInstance();

	try {
		int micsec = (int) (Math.abs(delta) % 1000000);
		double absDelta = Math.abs(delta) / 1000000;
		int hour = (int) (absDelta / 3600);
		int min = (int) ((absDelta % 3600) / 60);
		int sec = (int) ((absDelta % 3600) % 60);
		int hourValue = 0;				
		int minValue = 0;				
		int secValue = 0;
		int micsecValue = 0;
				
		if(delta>=0){
			hourValue = hour;
			minValue = min;
			secValue = sec;
			micsecValue = micsec;
		}else{
			hourValue = hour>0 ? -hour : hour;
			if(hourValue!=0){
				minValue = min;
			}else{ 
				if(min!=0){				
					minValue = -min;
				}else{
					minValue = 0;
				}
			}
			
			if(hourValue!=0 || minValue!=0){
				secValue = sec;
			}else{
				if(sec!=0){
					secValue = -sec;
				}else{
					secValue = sec;
				}
			}
			
			if(hourValue!=0 || minValue!=0 || secValue!=0){
				micsecValue = micsec;
			}else{
				if(micsec!=0){
					micsecValue = -micsec;
				}else{
					micsecValue = micsec;
				}
			}

		}
		_hour.setText(hourValue == 0 ? "" : String.valueOf(hourValue));
		_min.setText(minValue == 0 ? "" : String.valueOf(minValue));
		_sec.setText(secValue == 0 ? "" : String.valueOf(secValue));
		_micsec.setText(micsecValue == 0 ? "" : String.valueOf(micsecValue));
	} catch (Exception exc) {
		exc.printStackTrace();
	}
}

public void setShowDelta(boolean enable)
{
	deltaTime.setVisible(enable);
}


}
