/**********************************************************************
 * Copyright (c) 2005 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.ui.internal.filters;

import java.net.URL;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.filters.FiltersStandardTabUI;
import org.eclipse.hyades.trace.ui.filters.IAdvancedTabAttributeSet;
import org.eclipse.hyades.trace.ui.filters.internal.util.FilterType;
import org.eclipse.jface.resource.ImageDescriptor;

public class FilterTypesManager {
	private static FilterTypesManager instance;
	
	private Map filterTypes;
	private Map filterScopes;	
	
	protected final String FILTER_TYPES_EXTENTION_POINT = "filterTypes";
	
	
	
	protected FilterTypesManager()
	{
		
	}
	
	public static FilterTypesManager instance()
	{
		if (instance == null)
			instance = new FilterTypesManager();
		
		return instance;
	}
	
	public IFilterType[] getFilterTypes(String[] scope)
	{
		if (filterTypes == null)
			initialize();

		Vector filterTypesV = new Vector();
		for (int i = 0; i < scope.length; i++)
		{
			Vector filterTypesVi = (Vector)filterScopes.get(scope[i]);
		
			if (filterTypesVi != null)
			{
				for (int j = 0; j < filterTypesVi.size(); j++)
				{
					if (!filterTypesV.contains(filterTypesVi.elementAt(j)))
						filterTypesV.addElement(filterTypesVi.elementAt(j));
				}
			}
		}
		
		IFilterType[] iFilterTypes = new IFilterType[filterTypesV.size()];
		filterTypesV.toArray(iFilterTypes);
		
		return iFilterTypes;
	}
	
	public IFilterType getFilterType(String id)
	{
		if (filterTypes == null)
			initialize();
		
		return (IFilterType)filterTypes.get(id);
	}
	
	private void initialize()
	{
		filterTypes = new HashMap();
		filterScopes = new HashMap();
		
		IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(UIPlugin.PLUGIN_ID, FILTER_TYPES_EXTENTION_POINT);

		if (point != null) {
			IConfigurationElement[] elements = point.getConfigurationElements();
			
			for (int i = 0; i < elements.length; i++) {
				
				IConfigurationElement elem = elements[i];

				String id = elem.getAttribute("id");				
				String name = elem.getAttribute("name");
				
				if(id == null || name == null )
					 continue;

				String iconPath = elem.getAttribute("icon");
				ImageDescriptor icon = null;
				if(iconPath != null)
				{
					try {
						
						URL pluginInstallUrl = Platform.getBundle(elem.getDeclaringExtension().getNamespace()).getEntry("/"); //$NON-NLS-1$									
						icon = ImageDescriptor.createFromURL(new URL(pluginInstallUrl + iconPath));
						
					} catch (Exception e) {
						e.printStackTrace();
					}					
				}
				
				String description = elem.getAttribute("description");				

				FiltersStandardTabUI standardTabUI = null;
				IAdvancedTabAttributeSet advancedTabAttributeSet = null;
				try
				{
					if (!("".equals(elem.getAttribute("standardTabUI")) || elem.getAttribute("standardTabUI") == null))
						standardTabUI = (FiltersStandardTabUI)elem.createExecutableExtension("standardTabUI");
					
					if (!("".equals(elem.getAttribute("advancedAttributes")) || elem.getAttribute("advancedAttributes") == null))
						advancedTabAttributeSet = (IAdvancedTabAttributeSet)elem.createExecutableExtension("advancedAttributes");
				}
				catch (Exception e)
				{
					e.printStackTrace();
				}
				
				IConfigurationElement[] appliesToElems = elem.getChildren("appliesTo");

				Vector scopesV = new Vector();
				for (int k = 0; k < appliesToElems.length; k++)
					scopesV.addElement(appliesToElems[k].getAttribute("filterScope"));
				
				String[] scope = new String[scopesV.size()];
				scopesV.toArray(scope);
				
				if(standardTabUI != null || advancedTabAttributeSet != null)			
				{
					IFilterType filterType = new FilterType(id, name, icon, description, standardTabUI, advancedTabAttributeSet, scope);

					filterTypes.put(filterType.id(), filterType);

					for(int j = 0; j < filterType.scope().length; j++)
					{
						Vector filterTypesV = (Vector)filterScopes.get(filterType.scope()[j]);
						if (filterTypesV != null)
						{
							filterTypesV.addElement(filterType);
						}
						else
						{
							filterTypesV = new Vector();
							filterTypesV.addElement(filterType);							
							filterScopes.put(filterType.scope()[j], filterTypesV);
						}
					}
				}
			}
			
		}
	}
	
	public static String firstScopeIntersection(String[]scopeSorted, String[] scopeOther)
	{
		for (int i = 0; i < scopeOther.length; i++)
		{
			if (Arrays.binarySearch(scopeSorted, scopeOther[i],new Comparator() {
			public int compare(Object a, Object b) {
				String str1 = (String)a;
				String str2 = (String)b;
				
				if (str1 == null)
					str1 = "";//$NON-NLS-1$
				if (str2 == null)
					str2 = "";//$NON-NLS-1$
				
				return Collator.getInstance().compare(str1, str2);				
			}
			}  ) >= 0)
				return scopeOther[i];
		}
		
		return null;
		
	}
	
	public static boolean scopesHaveIntersection(String[]scopeSorted, String[] scopeOther)
	{
		return firstScopeIntersection(scopeSorted, scopeOther) != null;
	}
}
