/**********************************************************************
 * Copyright (c) 2005 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.ui.internal.filters;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsFactory;
import org.eclipse.hyades.models.hierarchy.extensions.RelationalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleOperand;


public class ModelUtils {

	public static BinaryExpression createBinaryExpression(EStructuralFeature feature, RelationalOperators operator, String value, boolean caseInsensitive)
	{
		String [] values = new String[1];
		values[0] = value;

		return createBinaryExpression(feature, operator, values, caseInsensitive);
	}
	
	public static BinaryExpression createBinaryExpression(EStructuralFeature feature, RelationalOperators operator, String[] values, boolean caseInsensitive)
	{
		BinaryExpression binaryExpression = ExtensionsFactory.eINSTANCE.createBinaryExpression(); 
		
		SimpleOperand leftOperand = ExtensionsFactory.eINSTANCE.createSimpleOperand();
		leftOperand.setFeature(feature);

		binaryExpression.setLeftOperand(leftOperand);
		
		binaryExpression.setOperator(operator);

		for (int i = 0; i < values.length; i++)
		{
			SimpleOperand rightOperand = ExtensionsFactory.eINSTANCE.createSimpleOperand();
	
			if (feature instanceof EAttribute)
				rightOperand.setValueType(((EAttribute)feature).getEAttributeType());
	
			rightOperand.setValue(values[i]);		
	
			binaryExpression.getRightOperands().add(rightOperand);
		}

		binaryExpression.setCaseInsensitive(caseInsensitive);
		
		return binaryExpression;
	}
}
