/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse
 * Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AgentAttribute.java,v 1.1 2005/04/19 23:24:25 ewchan Exp $
 * 
 * Contributors: IBM - Initial API and implementation
 ******************************************************************************/
package org.eclipse.hyades.trace.ui.internal.launcher;

import java.util.StringTokenizer;

import org.eclipse.hyades.internal.execution.local.control.Agent;


public class AgentAttribute
{
	private String _pid;
	private String _name;
	private String _type;
	
	public AgentAttribute(String pid, Agent agent)
	{
		_pid = pid;
		_name = agent.getName();
		_type = agent.getType();
	}
	
	public AgentAttribute(String agentAttributeString)
	{
		StringTokenizer tok = new StringTokenizer(agentAttributeString, ":");
		_pid = tok.nextToken();
		
		tok = new StringTokenizer(tok.nextToken(), ";");
		
		_name = tok.nextToken();
		_type = tok.nextToken();
	}
	
	public String getPID()
	{
		return _pid;
	}		
	
	public String getName()
	{
		return _name;
	}
	
	public String getType()
	{
		return _type;
	}
	
	public String getAttributeString()
	{
		return getPID() + ":" + getName() + ";" + getType();
	}
}
