/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ProfileDestinationTab.java,v 1.5 2005/02/16 22:24:01 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.ui.internal.launcher;

import org.eclipse.debug.core.*;
import org.eclipse.hyades.trace.ui.internal.core.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.core.runtime.*;
import org.eclipse.jface.preference.*;
import org.eclipse.hyades.trace.internal.ui.*;
import org.eclipse.swt.*;
import org.eclipse.swt.layout.*;
import org.eclipse.hyades.security.util.*;

/**
 * @author znensi
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class ProfileDestinationTab {
	
	private TraceLocationUI _destinationUI;
	private TraceFileUI _fileUI;
	private ProfileTab parentTab;
	
	public ProfileDestinationTab(ProfileTab pt)
	{
		_destinationUI = new TraceLocationUI();
		_fileUI = new TraceFileUI();
		parentTab = pt;
	}
	
	public Composite createControl(Composite parent)
	{
		
		Composite content = new Composite(parent, SWT.NULL);
		content.setLayout(new GridLayout());
		content.setLayoutData(GridUtil.createFill());
		_destinationUI.createControl(content);

		_fileUI.createControl(content);
		
		

		if (!UIPlugin.getDefault().getPreferenceStore().getBoolean(TraceConstants.PROF_OPTION_KEY))
			_fileUI.setVisible(false);

		
		return content;
		
		
	}
	
	public void addListener (Listener _listener)
	{
		_destinationUI.addListener(_listener);
		_fileUI.addListener(_listener);
	}
	
	public void activated(ILaunchConfigurationWorkingCopy conf)
	{
	}
	
	public void initializeFrom(ILaunchConfiguration conf)
	{
		try
		{
			IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
			String location = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_PROJECT, "");
			String monitor = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_MONITOR, "");
			String file = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_FILE, "");
			boolean profileToFile = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILE_TO_FILE, false);
			if (location.length() == 0) location = store.getString(TraceConstants.TRACE_PROJECT_NAME);
			if (monitor.length() == 0) monitor = store.getString(TraceConstants.TRACE_MONITOR_NAME);
			
			_destinationUI.setLocation(location);
			_destinationUI.setMonitor(monitor);
			_fileUI.setFile(file);
			_fileUI.setEnabled(profileToFile);
			_fileUI.getExternalBox().setSelection(profileToFile);
		}
		catch (CoreException e)
		{
			e.printStackTrace();
		}
	}
	
	public void performApply(ILaunchConfigurationWorkingCopy wc)
	{
		wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_PROJECT, _destinationUI.getLocation().getText().trim());
		wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_MONITOR, _destinationUI.getMonitor().getText().trim());
		wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILE_TO_FILE, _fileUI.getExternalBox().getSelection());
		wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_FILE, _fileUI.getFile());
	}
	
	public boolean isValid(ILaunchConfiguration conf)
	{
		parentTab.setErrorMessage(null);
		parentTab.setMessage(null);

		if (_destinationUI.getLocation().getText().trim().length() == 0)
		{
			parentTab.setErrorMessage(UIPlugin.getResourceString("TAB_ERROR_DESTINATION_PROJECT"));
			return false;
		}

		if (_destinationUI.getMonitor().getText().trim().length() == 0)
		{
			parentTab.setErrorMessage(UIPlugin.getResourceString("TAB_ERROR_DESTINATION_MONITOR"));
			return false;
		}

		if (_fileUI.getSelection() && _fileUI.getFile().trim().length() == 0)
		{
			parentTab.setErrorMessage(UIPlugin.getResourceString("TAB_ERROR_DESTINATION_FILE"));
			return false;
		}

		return true;
	}
	
	public void setDefaults(ILaunchConfigurationWorkingCopy wc)
	{
		IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
		wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_PROJECT, store.getString(TraceConstants.TRACE_PROJECT_NAME));
		wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_MONITOR, store.getString(TraceConstants.TRACE_MONITOR_NAME));
		wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_FILE, (String) null);
		wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILE_TO_FILE, false);
	}
}
