/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ProfileLimitsTab.java,v 1.7 2005/02/16 22:24:01 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.ui.internal.launcher;

import org.eclipse.debug.core.*;
import org.eclipse.hyades.trace.internal.ui.*;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceProfileCollectionsUI;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.*;

/**
 * @author znensi
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class ProfileLimitsTab {
	
	private TraceProfileCollectionsUI _limitsUI;
	private ProfileTab parentTab;
	
	public ProfileLimitsTab(ProfileTab pt, boolean attach)
	{
		_limitsUI = new TraceProfileCollectionsUI(attach);
		parentTab = pt;
	}
	
	public Composite createControl(Composite parent)
	{
		return _limitsUI.createControl(parent);
	}
	
	public void addListener (Listener _listener)
	{
		_limitsUI.addListener(_listener);
	}
	
	public void initializeFrom(ILaunchConfiguration conf)
	{
		IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
		try
		{
			
			_limitsUI.setLimitInvocations(conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_INVOCATIONS, store.getBoolean(TraceConstants.LIMIT_TRACE_INVOC_OPTION)));
			_limitsUI.setLimitInvocNb(String.valueOf(conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_INVOCATIONS_NUM, store.getInt(TraceConstants.LIMIT_INVOC_NB))));
			_limitsUI.setLimitTime(conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_SECONDS, store.getBoolean(TraceConstants.LIMIT_TRACE_TIME_OPTION)));
			_limitsUI.setLimitTimeNb(String.valueOf(conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_SECONDS_NUM, store.getInt(TraceConstants.LIMIT_TIME_NB))));
			_limitsUI.setAutoMonitoring(conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_AUTO_MONITORING, store.getBoolean(TraceConstants.PROF_AUTO_MONITOR)));
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}

	}
	
	public void performApply(ILaunchConfigurationWorkingCopy wc)
	{
		wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_INVOCATIONS, _limitsUI.getLimitInvocations());
		wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_INVOCATIONS_NUM, _limitsUI.getLimitInvocNb());
		wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_SECONDS, _limitsUI.getLimitTime());
		wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_SECONDS_NUM, _limitsUI.getLimitTimeNb());
		wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_AUTO_MONITORING, _limitsUI.getAutoMonitoring());
		
	}
	
	public boolean isValid(ILaunchConfiguration conf)
	{
		parentTab.setErrorMessage(null);
		parentTab.setMessage(null);

		try
		{
			if (_limitsUI.getLimitInvocations())
			{
				int num = _limitsUI.getLimitInvocNb();
				
				if (num < 1)
				{
					parentTab.setErrorMessage(UIPlugin.getResourceString("TAB_ERROR_LIMITS_INVOCATIONS"));
					return false;
				}
			}
		}
		catch (NumberFormatException e)
		{
			parentTab.setErrorMessage(UIPlugin.getResourceString("TAB_ERROR_LIMITS_INVOCATIONS"));
			return false;
		}

		try
		{
			if (_limitsUI.getLimitTime())
			{
				int num = _limitsUI.getLimitTimeNb();
				
				if (num < 1)
				{
					parentTab.setErrorMessage(UIPlugin.getResourceString("TAB_ERROR_LIMITS_TIME"));
					return false;
				}
			}
		}
		catch (NumberFormatException e)
		{
			parentTab.setErrorMessage(UIPlugin.getResourceString("TAB_ERROR_LIMITS_TIME"));
			return false;
		}

		return true;
	}
	
	public void setDefaults(ILaunchConfigurationWorkingCopy wc)
	{
		IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
		wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_INVOCATIONS, store.getBoolean(TraceConstants.LIMIT_TRACE_INVOC_OPTION));
		wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_INVOCATIONS_NUM, store.getInt(TraceConstants.LIMIT_INVOC_NB));
		wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_SECONDS, store.getBoolean(TraceConstants.LIMIT_TRACE_TIME_OPTION));
		wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_LIMIT_SECONDS_NUM, store.getInt(TraceConstants.LIMIT_TIME_NB));
		wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_AUTO_MONITORING, store.getBoolean(TraceConstants.PROF_AUTO_MONITOR));
	}
	public String getName()
	{
		return UIPlugin.getResourceString("TAB_NAME_LIMITS");
	}

	public Image getImage()
	{
		return PDPluginImages.getImage(PDPluginImages.IMG_OPTIONS);
	}

}
