/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ProfileMainTab.java,v 1.8 2005/02/16 22:24:01 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.launcher;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.LaunchProcessUI;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class ProfileMainTab extends AbstractLaunchConfigurationTab {
	private ProfileHostTab _hostTab;

	private LaunchProcessUI _ui;

	public ProfileMainTab(ProfileHostTab hostTab) {
		_hostTab = hostTab;
	}

	public void createControl(Composite parent) {
		Composite content = new Composite(parent, SWT.NONE);
		setControl(content);
		content.setLayout(new GridLayout());
		createVerticalSpacer(content, 1);

		_ui = new LaunchProcessUI();
		_ui.createControl(content);
		_ui.enable(true);
		_ui.setLocalButtons(_hostTab.isLocal());
		_ui.addListener(new Listener() {
			public void handleEvent(Event event) {
				// the values changed; update
				updateLaunchConfigurationDialog();
			}
		});
	}

	public Image getImage() {
		return PDPluginImages.getImage(PDPluginImages.IMG_UI_CLASS);
	}

	public String getName() {
		return UIPlugin.getResourceString("TAB_NAME_MAIN");
	}

	public void initializeFrom(ILaunchConfiguration conf) {
		_ui.enable(true);
		_ui.setLocalButtons(_hostTab.isLocal());

		try {
			String className = conf.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "");
			String classPath = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_CLASSPATH, "");
			String programArgs = conf.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, "");
			String vmArgs = conf.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, "");

			_ui.setClassName(className);
			_ui.setClassPath(classPath);
		} catch (CoreException e) {
			HyadesUIPlugin.logError(e);
		}
	}

	public boolean isValid(ILaunchConfiguration config) {
		setErrorMessage(null);
		setMessage(null);
		
		if (!isValidClassName(_ui.getClassName())) {
			setErrorMessage(UIPlugin.getResourceString("TAB_ERROR_CLASSNAME"));
			return false;
		}
		if (_ui.getClassName().trim().length() == 0) {
			setErrorMessage(UIPlugin.getResourceString("TAB_ERROR_MAIN"));
			return false;
		}
		if (_ui.getClassPath().trim().length() == 0) {
			setErrorMessage(UIPlugin.getResourceString("TAB_ERROR_CLASSPATH"));
			return false;
		}
		return true;
	}

	public void performApply(ILaunchConfigurationWorkingCopy wc) {
		wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, _ui.getClassName());
		wc.setAttribute(IProfileLaunchConfigurationConstants.ATTR_CLASSPATH, _ui.getClassPath());
	}

	public void setDefaults(ILaunchConfigurationWorkingCopy wc) {
	}
			
	/**
	 * Check if class name is valid. Valid names do not contain
	 * any whitespace.
	 * 
	 * @param str the class name
	 * @return true if the class name is valid, false otherwise
	 */
	public boolean isValidClassName(String str) 
	{   
	    char[] buf = str.toCharArray();
	    for(int i=0; i<buf.length; i++) {	    	
	        switch(buf[i]) {
	                case ' ':
	                case '\t':
	                case '\n':
	                case '\r':
	                case '\b':
	                	return false;	                
	            }
	        }    
        return true;
    }

}