/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ProfilingSetTypeGroup.java,v 1.4 2005/02/16 22:24:01 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.launcher;

import org.eclipse.hyades.trace.ui.launcher.IProfilingSetTypeGroup;
import org.eclipse.jface.resource.ImageDescriptor;

public class ProfilingSetTypeGroup implements IProfilingSetTypeGroup{
	
	protected String id;
	protected String name;
	protected String description;
	protected ImageDescriptor icon;
	/**
	 * @return Returns the icon.
	 */
	public ImageDescriptor getIcon() {
		return icon;
	}
	/**
	 * @param icon The icon to set.
	 */
	public void setIcon(ImageDescriptor icon) {
		this.icon = icon;
	}
	/**
	 * @return Returns the id.
	 */
	public String getId() {
		return id;
	}
	/**
	 * @param id The id to set.
	 */
	public void setId(String id) {
		this.id = id;
	}
	/**
	 * @return Returns the name.
	 */
	public String getName() {
		return name;
	}
	/**
	 * @param name The name to set.
	 */
	public void setName(String name) {
		this.name = name;
	}
	
	/**
	 * @return Returns the description.
	 */
	public String getDescription() {
		return description;
	}
	/**
	 * @param name The description to set.
	 */
	public void setDescription(String description) {
		this.description = description;
	}
	
	/**
	 * 
	 * @param id
	 * @param name
	 * @param description
	 * @param icon
	 */
	public ProfilingSetTypeGroup(String id, String name, String description, ImageDescriptor icon) {
		super();
		this.id = id;
		this.name = name;
		this.icon = icon;
		this.description = description;
	}
}
