/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ExecutionTimeUI.java,v 1.14 2005/04/27 22:43:25 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.launcher.defaults;


import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.internal.ui.TraceConstants;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;

/*
 * CONTEXT_ID topp0002 for collect boundary classes checkbox
 */
/*
 * CONTEXT_ID topp0008 for boundary class depth text field
 */
/*
 * CONTEXT_ID topp0009 for show exec flow radio button set
 */
/*
 * CONTEXT_ID topp0011 for show instance lvl info checkbox
 */
public class ExecutionTimeUI implements SelectionListener{
		
	private Composite _detailsHeapGroup;
	private Button _showHeapInstance;
	private Button _collectCPUtime;

	private Button _boundary;
	private Label _traceDepthLabel;
	private Text _traceDepth;

	private Composite _detailsExecGroup;
	private Button _showExecStatistic;
	private Button _showExecFlow;
	
	private Label titleLabel;
	private Label optionsLabel;
	
	private Button _advancedOptions;
	private Composite _heapOptionGrp;

	public ExecutionTimeUI() {
		super();
	}

	public Composite createControl(Composite parent) {
		
		GridLayout layout;

		Composite result = new Composite(parent, SWT.NONE);

		layout = new GridLayout();
		layout.numColumns = 1;
		layout.verticalSpacing = 2;

		GridData data = GridUtil.createFill();
		result.setLayout(layout);
		result.setLayoutData(data);
		
		titleLabel = new Label(result, SWT.NULL);
		titleLabel.setText(UIPlugin.getResourceString("executionGroup"));
		titleLabel.setLayoutData(GridUtil.createHorizontalFill());
		//white
		titleLabel.setBackground(Display.getCurrent().getSystemColor(SWT.COLOR_WHITE));
		Font font = titleLabel.getFont();
		if (font != null) {
			FontData[] fonts = font.getFontData();
			if (fonts != null && fonts.length >= 1) {
				titleLabel.setFont(new Font(Display.getDefault(), fonts[0].getName(), fonts[0].getHeight() + 3, SWT.BOLD));
			}
		}

		new Label(result, SWT.NULL);
		
		optionsLabel = new Label(result, SWT.WRAP);
		optionsLabel.setText(UIPlugin.getResourceString("STR_ANALYZE_EXE_TIME"));
		data = new GridData();
		data.horizontalIndent = 20;
		data.widthHint = 375;
		optionsLabel.setLayoutData(data);

		Composite grp = new Composite(result, SWT.NULL);
		data = GridUtil.createHorizontalFill();
		layout = new GridLayout();
		layout.numColumns = 1;
		grp.setLayout(layout);
		grp.setLayoutData(data);

		addExecutionOption(grp);
		addHeapOption(grp);
		
		_detailsHeapGroup.setVisible(true);
		_detailsExecGroup.setVisible(true);
		_traceDepth.setEnabled(_boundary.getSelection() );

		return result;
	}

	public void enableButtons()
	{
		_traceDepth.setEnabled(_boundary.getSelection() );
		enableHeapInstance(_showExecFlow.getSelection());
	}
	
	private void addHeapOption(Composite parent) {
		GridLayout layout;
		GridData data;

		_detailsHeapGroup = new Composite(parent, SWT.NULL);
		data = GridUtil.createHorizontalFill();
		data.horizontalIndent = 20;
		_detailsHeapGroup.setLayoutData(data);
		layout = new GridLayout();
		layout.numColumns = 1;
		_detailsHeapGroup.setLayout(layout);

		_advancedOptions = new Button(_detailsHeapGroup, SWT.PUSH);
		_advancedOptions.setText(UIPlugin.getResourceString("STR_ADVANCED_BTN"));
		_advancedOptions.addSelectionListener(this);

		_heapOptionGrp = new Composite(_detailsHeapGroup, SWT.NULL);
		_heapOptionGrp.setLayout(new GridLayout());
		
		_showHeapInstance = new Button(_heapOptionGrp, SWT.CHECK);
		_showHeapInstance.setText(
				UIPlugin.getResourceString("STR_SHOW_INST_LEVEL_INFO"));						
		
		Label info = new Label(_heapOptionGrp, SWT.WRAP);
		data = GridUtil.createHorizontalFill();
		info.setLayoutData(data);
		info.setForeground(Display.getCurrent().getSystemColor(SWT.COLOR_RED));
		info.setText(UIPlugin.getResourceString("STR_INSTANCE_LEVEL_INFO"));
		
		_heapOptionGrp.setVisible(false);

		org.eclipse.ui.help.WorkbenchHelp.setHelp(
				_showHeapInstance,
				UIPlugin.getPluginId() + ".topp0011");
	}

	
	private void addExecutionOption(Composite parent) {
		
		GridLayout layout;
		GridData data;
		
		_detailsExecGroup = new Composite(parent, SWT.NULL);
		data = GridUtil.createHorizontalFill();
		data.horizontalIndent = 20;
		_detailsExecGroup.setLayoutData(data);
		layout = new GridLayout();
		layout.numColumns = 2;
		_detailsExecGroup.setLayout(layout);

		_collectCPUtime = new Button(_detailsExecGroup, SWT.CHECK);
		_collectCPUtime.setText(
				UIPlugin.getResourceString("STR_COLLECT_CPU_TIME"));
		
		_boundary = new Button(_detailsExecGroup, SWT.CHECK);
		data = GridUtil.createHorizontalFill();
		data.horizontalSpan = 2;
		_boundary.setLayoutData(data);
		_boundary.setText(
			UIPlugin.getResourceString("AGENT_UI_BOUNDARY_CLASS"));

		_traceDepthLabel = new Label(_detailsExecGroup, SWT.NULL);
		_traceDepthLabel.setText(
			UIPlugin.getResourceString("STR_COLLECT_DEPTH"));
		_traceDepth = new Text(_detailsExecGroup, SWT.BORDER);
		data = new GridData();
		data.widthHint = 70;
		_traceDepth.setLayoutData(data);

		Group _showExecGroup = new Group(_detailsExecGroup, SWT.NULL);
		data = GridUtil.createHorizontalFill();
		data.horizontalSpan = 2;
		_showExecGroup.setLayoutData(data);
		layout = new GridLayout();
		layout.numColumns = 1;
		_showExecGroup.setLayout(layout);

		_showExecStatistic = new Button(_showExecGroup, SWT.RADIO);
		_showExecStatistic.setText(UIPlugin.getResourceString("EXEC_STAT"));
		_showExecFlow = new Button(_showExecGroup, SWT.RADIO);
		_showExecFlow.setText(UIPlugin.getResourceString("DETAILED_DATA"));

		_boundary.addSelectionListener(this);
		_showExecStatistic.addSelectionListener(this);
		_showExecFlow.addSelectionListener(this);

		org.eclipse.ui.help.WorkbenchHelp.setHelp(
			_boundary,
			UIPlugin.getPluginId() + ".topp0002");
		org.eclipse.ui.help.WorkbenchHelp.setHelp(
			_traceDepth,
			UIPlugin.getPluginId() + ".topp0008");
		org.eclipse.ui.help.WorkbenchHelp.setHelp(
			_showExecGroup,
			UIPlugin.getPluginId() + ".topp0009");

	}

	public void enable(boolean enable) {
	
		enableExecutionButtons(true);
	}

	public void enableExecutionButtons(boolean enable) {
		_boundary.setEnabled(enable);

		_traceDepth.setEnabled(enable);
		_traceDepthLabel.setEnabled(enable);

		_showExecStatistic.setEnabled(enable);
		_showExecFlow.setEnabled(enable);
	}

	public void enableBtnGroup() {
		enableExecutionBtnGroup();
	}


	


	private void enableExecutionBtnGroup() {
		_boundary.setEnabled(true);

		_showExecFlow.setEnabled(true);
		_showExecStatistic.setEnabled(true);

		_traceDepth.setEnabled(_boundary.getSelection());
		_traceDepthLabel.setEnabled(_boundary.getSelection());
	}



	private boolean checkValidTraceDepth() {
		if (_boundary.getSelection()) {
			String text = _traceDepth.getText().trim();
			try {
				if (Integer.parseInt(text) <= 0)
					return false;
			} catch (Exception exc) {
				return false;
			}
		}
		return true;
	}

	public boolean getExecutionStatistic() {
		return _showExecStatistic.getSelection();
	}
	
	public boolean getExecutionFlow() {
		return _showExecFlow.getSelection();
	}

	public boolean getExecutionBoundary() {
		return _boundary.getSelection();
	}
	
	public boolean getInstance()
	{
		return _showHeapInstance.getSelection();
	}
	
	public boolean getCPUtime()
	{
		return _collectCPUtime.getSelection();
	}
	
	public void setInstance(boolean selection)
	{
		_showHeapInstance.setSelection(selection);
	}
	
	public void setCPUtime(boolean selection)
	{
		_collectCPUtime.setSelection(selection);
	}


	public int getCollectionDepth() {
		String text = _traceDepth.getText().trim();

		try {
			int depth = Integer.parseInt(text);
			if (depth > 0)
				return depth;
			else
				return UIPlugin
					.getDefault()
					.getPreferenceStore()
					.getDefaultInt(
					TraceConstants.COLLECT_DEPTH);
		} catch (Exception exc) {
			return UIPlugin.getDefault().getPreferenceStore().getDefaultInt(
				TraceConstants.COLLECT_DEPTH);
		}
	}




	public void setExecutionStatistic(boolean select) {
		_showExecStatistic.setSelection(select);
	}

	public void setExecutionFlow(boolean select) {
		_showExecFlow.setSelection(select);
	}

	public void setExecutionBoundary(boolean setValue) {
		_boundary.setSelection(setValue);

		_traceDepth.setEnabled(_boundary.getSelection());
		_traceDepthLabel.setEnabled(_boundary.getSelection());

	}

	public void setCollectionDepth(String value) {
		_traceDepth.setText(value);
	}
	
	public void enableHeapInstance(boolean enable) {
		if (enable==false) _showHeapInstance.setSelection(enable);
		_showHeapInstance.setEnabled(enable);
	}

	public void widgetDefaultSelected(SelectionEvent event) {
	}

	public void widgetSelected(SelectionEvent event) {
		if (event.widget == _boundary) {
			_traceDepth.setEnabled(_boundary.getSelection());
			_traceDepthLabel.setEnabled(_boundary.getSelection());
		}
		else if (event.widget == _showExecStatistic) {
			enableHeapInstance(_showExecFlow.getSelection());
		}
		else if (event.widget == _showExecFlow) {
			enableHeapInstance(_showExecFlow.getSelection());
		}
		else if (event.widget == _advancedOptions) {
			_heapOptionGrp.setVisible(!_heapOptionGrp.getVisible());
		}
		
	}

}
