/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: FilterElementModifier.java,v 1.4 2005/02/16 22:24:01 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.util;

import org.eclipse.swt.widgets.*;
import org.eclipse.jface.viewers.*;

public class FilterElementModifier implements ICellModifier
{
	protected CheckboxTableViewer fViewer;

	public FilterElementModifier(CheckboxTableViewer viewer)
	{
		fViewer = viewer;
	}
	public boolean canModify(Object element, String property) {
		return true;
	}
	public Object getValue(Object element, String property)
	{
		  
		if(property.equals(FilterTableElement.P_TEXT))
		  return ((FilterTableElement)element).getText();

		if(property.equals(FilterTableElement.P_METHOD))
		  return ((FilterTableElement)element).getMethod();

		if(property.equals(FilterTableElement.P_VISIBILITY))
		  return new Integer(((FilterTableElement)element).getVisibilityState());
		  
		return element;
	}
	public void modify(Object element, String property, Object value)
	{
		try {
		if(element instanceof TableItem)
		{
			Item item = (Item)element;			
			Object data = ((TableItem)element).getData();
			
			if(data != null && data instanceof FilterTableElement)
			{
				FilterTableElement e = (FilterTableElement)data;

				if (FilterTableElement.P_TEXT.equals(property))
				{
					if(value != null && !e.getText().equals(value.toString()))
					{
						e.setText(value.toString());
					}
						
				}
				else if (FilterTableElement.P_METHOD.equals(property))
				{
					if(value != null && !e.getMethod().equals(value.toString()))
					{
						e.setMethod(value.toString());
					}
						
				}
				
				else if (FilterTableElement.P_VISIBILITY.equals(property))
				{
					if(value != null && Integer.parseInt(value.toString()) != e.getVisibilityState())
					{
						e.setVisibility(Integer.parseInt(value.toString()));
					}
				}				
			}	
		}
		}
		catch(Exception exc)
		{
			exc.printStackTrace();
		}
	}

}
